/*
 * Decompiled with CFR 0.152.
 */
package com.phantomwing.rusticdelight;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import com.phantomwing.rusticdelight.Configuration;
import com.phantomwing.rusticdelight.block.ModBlocks;
import com.phantomwing.rusticdelight.item.ModItems;
import com.phantomwing.rusticdelight.loot.LootModifierManager;
import com.phantomwing.rusticdelight.potions.ModPotions;
import com.phantomwing.rusticdelight.ui.ModCreativeModTab;
import com.phantomwing.rusticdelight.world.ModPlacementModifiers;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.slf4j.Logger;

@Mod(value="rusticdelight")
public class RusticDelight {
    public static final String MOD_ID = "rusticdelight";
    private static final Logger LOGGER = LogUtils.getLogger();

    public RusticDelight(IEventBus eventBus, ModContainer modContainer) {
        eventBus.addListener(this::commonSetup);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Configuration.COMMON_CONFIG);
        if (FMLEnvironment.dist.isClient()) {
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }
        NeoForge.EVENT_BUS.register((Object)this);
        this.registerManagers(eventBus);
    }

    private void registerManagers(IEventBus eventBus) {
        ModItems.register(eventBus);
        ModBlocks.register(eventBus);
        ModPotions.register(eventBus);
        LootModifierManager.register(eventBus);
        ModCreativeModTab.register(eventBus);
        ModPlacementModifiers.register(eventBus);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            this.addFlowerPots();
            RusticDelight.registerItemSetAdditions();
        });
    }

    private void addFlowerPots() {
        FlowerPotBlock flowerPotBlock = (FlowerPotBlock)Blocks.FLOWER_POT;
        flowerPotBlock.addPlant(ModBlocks.WILD_COTTON.getId(), ModBlocks.POTTED_WILD_COTTON);
        flowerPotBlock.addPlant(ModBlocks.WILD_BELL_PEPPERS.getId(), ModBlocks.POTTED_WILD_BELL_PEPPERS);
        flowerPotBlock.addPlant(ModBlocks.WILD_COFFEE.getId(), ModBlocks.POTTED_WILD_COFFEE);
    }

    public static void registerItemSetAdditions() {
        HashSet newWantedItems = Sets.newHashSet((Object[])new Item[]{(Item)ModItems.BELL_PEPPER_GREEN.get(), (Item)ModItems.BELL_PEPPER_YELLOW.get(), (Item)ModItems.BELL_PEPPER_RED.get(), (Item)ModItems.COTTON_BOLL.get(), (Item)ModItems.BELL_PEPPER_SEEDS.get(), (Item)ModItems.COTTON_SEEDS.get(), (Item)ModItems.COFFEE_BEANS.get()});
        newWantedItems.addAll(Villager.WANTED_ITEMS);
        Villager.WANTED_ITEMS = ImmutableSet.copyOf((Collection)newWantedItems);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @EventBusSubscriber(modid="rusticdelight", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }
    }
}

