/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.misc;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gripe._90.megacells.definition.MEGAComponents;
import gripe._90.megacells.definition.MEGAItems;
import gripe._90.megacells.misc.CompressionChain;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class DecompressionPattern
implements IPatternDetails {
    private final AEItemKey definition;
    private final Item base;
    private final Item variant;
    private final int factor;
    private final boolean toCompress;

    public DecompressionPattern(Item base, CompressionChain.Variant variant, boolean toCompress) {
        this.base = base;
        this.variant = variant.item();
        this.factor = variant.factor();
        this.toCompress = toCompress;
        ItemStack definition = new ItemStack(MEGAItems.SKY_STEEL_INGOT);
        definition.set(MEGAComponents.ENCODED_DECOMPRESSION_PATTERN, (Object)new Encoded(base.getDefaultInstance(), variant.item().getDefaultInstance(), variant.factor(), toCompress));
        this.definition = AEItemKey.of((ItemStack)definition);
    }

    public AEItemKey getDefinition() {
        return this.definition;
    }

    public IPatternDetails.IInput[] getInputs() {
        return new IPatternDetails.IInput[]{this.toCompress ? new Input(this.base, this.factor) : new Input(this.variant, 1)};
    }

    public List<GenericStack> getOutputs() {
        return Collections.singletonList(this.toCompress ? new GenericStack((AEKey)AEItemKey.of((ItemLike)this.variant), 1L) : new GenericStack((AEKey)AEItemKey.of((ItemLike)this.base), (long)this.factor));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof DecompressionPattern)) return false;
        DecompressionPattern pattern = (DecompressionPattern)obj;
        if (!pattern.definition.equals((Object)this.definition)) return false;
        return true;
    }

    public int hashCode() {
        return this.definition.hashCode();
    }

    public record Encoded(ItemStack base, ItemStack variant, int factor, boolean toCompress) {
        public static final Codec<Encoded> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.CODEC.fieldOf("base").forGetter(Encoded::base), (App)ItemStack.CODEC.fieldOf("variant").forGetter(Encoded::variant), (App)Codec.INT.fieldOf("factor").forGetter(Encoded::factor), (App)Codec.BOOL.fieldOf("toCompress").forGetter(Encoded::toCompress)).apply((Applicative)instance, Encoded::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Encoded> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, Encoded::base, (StreamCodec)ItemStack.STREAM_CODEC, Encoded::variant, (StreamCodec)ByteBufCodecs.VAR_INT, Encoded::factor, (StreamCodec)ByteBufCodecs.BOOL, Encoded::toCompress, Encoded::new);
    }

    private record Input(Item input, int factor) implements IPatternDetails.IInput
    {
        public GenericStack[] getPossibleInputs() {
            return new GenericStack[]{new GenericStack((AEKey)AEItemKey.of((ItemLike)this.input), 1L)};
        }

        public long getMultiplier() {
            return this.factor;
        }

        public boolean isValid(AEKey input, Level level) {
            return input.matches(this.getPossibleInputs()[0]);
        }

        public AEKey getRemainingKey(AEKey template) {
            return null;
        }
    }
}

