/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.misc;

import appeng.api.networking.GridServices;
import appeng.api.stacks.AEItemKey;
import gripe._90.megacells.definition.MEGADataMaps;
import gripe._90.megacells.definition.MEGATags;
import gripe._90.megacells.misc.CompressionChain;
import gripe._90.megacells.misc.DecompressionService;
import gripe._90.megacells.misc.SyncCompressionChainsPacket;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompressionService.class);
    private static final CompressionChain EMPTY = new CompressionChain(List.of());
    private static final Set<CompressionChain> chains = new HashSet<CompressionChain>();
    private static final Set<Override> overrides = new HashSet<Override>();

    public static CompressionChain getChain(AEItemKey item) {
        return item != null ? CompressionService.getChain(item.getItem()) : EMPTY;
    }

    public static CompressionChain getChain(Item item) {
        for (CompressionChain chain : chains) {
            if (!chain.containsVariant(item)) continue;
            return chain;
        }
        return EMPTY;
    }

    public static void init() {
        GridServices.register(DecompressionService.class, DecompressionService.class);
        NeoForge.EVENT_BUS.addListener(ServerStartedEvent.class, event -> {
            MinecraftServer server = event.getServer();
            CompressionService.loadRecipes(server.getRecipeManager(), (RegistryAccess)server.registryAccess());
        });
        NeoForge.EVENT_BUS.addListener(OnDatapackSyncEvent.class, event -> {
            if (event.getPlayer() == null) {
                MinecraftServer server = event.getPlayerList().getServer();
                CompressionService.loadRecipes(server.getRecipeManager(), (RegistryAccess)server.registryAccess());
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SyncCompressionChainsPacket(chains), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                PacketDistributor.sendToPlayer((ServerPlayer)event.getPlayer(), (CustomPacketPayload)new SyncCompressionChainsPacket(chains), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        });
    }

    public static void syncToClient(SyncCompressionChainsPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            chains.clear();
            chains.addAll(packet.chains());
        });
    }

    private static void loadRecipes(RecipeManager recipeManager, RegistryAccess access) {
        chains.clear();
        overrides.clear();
        ArrayList<CraftingRecipe> compressed = new ArrayList<CraftingRecipe>();
        ArrayList<CraftingRecipe> decompressed = new ArrayList<CraftingRecipe>();
        for (RecipeHolder recipe2 : recipeManager.getAllRecipesFor(RecipeType.CRAFTING)) {
            if (CompressionService.isCompressionRecipe((CraftingRecipe)recipe2.value(), access)) {
                compressed.add((CraftingRecipe)recipe2.value());
                continue;
            }
            if (!CompressionService.isDecompressionRecipe((CraftingRecipe)recipe2.value())) continue;
            decompressed.add((CraftingRecipe)recipe2.value());
        }
        compressed.removeIf(recipe -> CompressionService.isIrreversible(recipe, decompressed, access));
        decompressed.removeIf(recipe -> CompressionService.isIrreversible(recipe, compressed, access));
        Comparator<CraftingRecipe> ingredientSize = Comparator.comparingInt(r -> ((Ingredient)r.getIngredients().getFirst()).getItems().length);
        compressed.sort(ingredientSize);
        decompressed.sort(ingredientSize);
        Stream.concat(compressed.stream(), decompressed.stream()).forEach(recipe -> {
            Item baseVariant = recipe.getResultItem((HolderLookup.Provider)access).getItem();
            if (CompressionService.getChain(baseVariant).isEmpty()) {
                chains.add(CompressionService.generateChain(baseVariant, compressed, decompressed, access));
            }
        });
        LOGGER.info("Initialised bulk compression. {} compression chains gathered.", (Object)chains.size());
    }

    private static CompressionChain generateChain(Item baseVariant, List<CraftingRecipe> compressed, List<CraftingRecipe> decompressed, RegistryAccess access) {
        LinkedList<Item> variants = new LinkedList<Item>();
        LinkedList<Integer> multipliers = new LinkedList<Integer>();
        variants.addFirst(baseVariant);
        CompressionChain.Variant lower = CompressionService.getNextVariant(baseVariant, decompressed, false, access);
        while (lower != null) {
            Item item = lower.item();
            if (variants.contains(item)) {
                if (lower.factor() == 1) break;
                LOGGER.warn("Duplicate lower compression variant detected: {}. Check any recipe involving this item for problems.", (Object)lower);
                break;
            }
            variants.addFirst(item);
            multipliers.addFirst(lower.factor());
            lower = CompressionService.getNextVariant(item, decompressed, false, access);
        }
        multipliers.addFirst(1);
        ObjectArrayList chain = new ObjectArrayList();
        for (int i = 0; i < variants.size(); ++i) {
            chain.add((Object)new CompressionChain.Variant((Item)variants.get(i), (Integer)multipliers.get(i)));
        }
        CompressionChain.Variant higher = CompressionService.getNextVariant(baseVariant, compressed, true, access);
        while (higher != null) {
            if (chain.contains((Object)higher)) {
                if (higher.factor() == 1) break;
                LOGGER.warn("Duplicate higher compression variant detected: {}. Check any recipe involving this item for problems.", (Object)higher);
                break;
            }
            chain.add((Object)higher);
            higher = CompressionService.getNextVariant(higher.item(), compressed, true, access);
        }
        LOGGER.debug("Gathered bulk compression chain: {}", (Object)chain);
        return new CompressionChain((List<CompressionChain.Variant>)chain);
    }

    private static CompressionChain.Variant getNextVariant(Item item, List<CraftingRecipe> recipes, boolean compressed, RegistryAccess access) {
        for (Override override : overrides) {
            if (compressed && override.smaller.equals(item)) {
                return new CompressionChain.Variant(override.larger, override.factor);
            }
            if (compressed || !override.larger.equals(item)) continue;
            return new CompressionChain.Variant(override.smaller, override.factor);
        }
        for (CraftingRecipe recipe : recipes) {
            for (ItemStack input : ((Ingredient)recipe.getIngredients().getFirst()).getItems()) {
                if (!input.getItem().equals(item)) continue;
                return new CompressionChain.Variant(recipe.getResultItem((HolderLookup.Provider)access).getItem(), compressed ? recipe.getIngredients().size() : recipe.getResultItem((HolderLookup.Provider)access).getCount());
            }
        }
        return null;
    }

    private static boolean isDecompressionRecipe(CraftingRecipe recipe) {
        return recipe.getIngredients().stream().filter(i -> !i.isEmpty()).count() == 1L;
    }

    private static boolean isCompressionRecipe(CraftingRecipe recipe, RegistryAccess access) {
        if (recipe.getResultItem((HolderLookup.Provider)access).getCount() != 1) {
            return false;
        }
        List<Ingredient> ingredients = recipe.getIngredients().stream().filter(i -> !i.isEmpty()).distinct().toList();
        if (ingredients.isEmpty()) {
            return false;
        }
        if (ingredients.size() == 1) {
            return true;
        }
        ItemStack[] first = ingredients.getFirst().getItems();
        for (Ingredient ingredient : ingredients) {
            ItemStack[] stacks = ingredient.getItems();
            if (stacks.length != first.length) {
                return false;
            }
            for (int i2 = 0; i2 < stacks.length; ++i2) {
                if (ItemStack.isSameItemSameComponents((ItemStack)stacks[i2], (ItemStack)first[i2])) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isIrreversible(CraftingRecipe recipe, List<CraftingRecipe> candidates, RegistryAccess access) {
        if (CompressionService.overrideRecipe(recipe, access)) {
            return false;
        }
        ItemStack[] testInput = ((Ingredient)recipe.getIngredients().getFirst()).getItems();
        Item testOutput = recipe.getResultItem((HolderLookup.Provider)access).getItem();
        for (CraftingRecipe candidate : candidates) {
            boolean sameQuantity;
            ItemStack[] input = ((Ingredient)candidate.getIngredients().getFirst()).getItems();
            Item output = candidate.getResultItem((HolderLookup.Provider)access).getItem();
            boolean compressible = false;
            boolean decompressible = false;
            for (ItemStack i : input) {
                if (!i.is(testOutput) || CompressionService.isBlacklisted(i)) continue;
                compressible = true;
                break;
            }
            for (ItemStack i : testInput) {
                if (!i.is(output) || CompressionService.isBlacklisted(i)) continue;
                decompressible = true;
                break;
            }
            boolean bl = sameQuantity = candidate.getResultItem((HolderLookup.Provider)access).getCount() == recipe.getIngredients().size() && recipe.getResultItem((HolderLookup.Provider)access).getCount() == candidate.getIngredients().size();
            if (!compressible || !decompressible || !sameQuantity) continue;
            return false;
        }
        return true;
    }

    private static boolean overrideRecipe(CraftingRecipe recipe, RegistryAccess access) {
        int n = 0;
        ItemStack[] itemStackArray = ((Ingredient)recipe.getIngredients().getFirst()).getItems();
        int n2 = itemStackArray.length;
        if (n < n2) {
            ItemStack input = itemStackArray[n];
            if (CompressionService.isBlacklisted(input)) {
                return false;
            }
            Item inputVariant = (Item)input.getItemHolder().getData(MEGADataMaps.COMPRESSION_OVERRIDE);
            if (inputVariant == null && !input.is(MEGATags.COMPRESSION_OVERRIDES)) {
                return false;
            }
            ItemStack output = recipe.getResultItem((HolderLookup.Provider)access);
            if (CompressionService.isBlacklisted(output)) {
                return false;
            }
            if (inputVariant != null && inputVariant != output.getItem()) {
                return false;
            }
            boolean decompressed = CompressionService.isDecompressionRecipe(recipe);
            Item smaller = (decompressed ? output : input).getItem();
            Item larger = (decompressed ? input : output).getItem();
            int factor = !decompressed ? recipe.getIngredients().size() : output.getCount();
            Override override = new Override(smaller, larger, factor);
            LOGGER.debug("Found bulk compression override: {}", (Object)override);
            overrides.add(override);
            return true;
        }
        return false;
    }

    private static boolean isBlacklisted(ItemStack stack) {
        return stack.is(MEGATags.COMPRESSION_BLACKLIST) || stack.getItemHolder().getData(MEGADataMaps.COMPRESSION_OVERRIDE) == Items.AIR;
    }

    private record Override(Item smaller, Item larger, int factor) {
        @java.lang.Override
        public String toString() {
            return String.valueOf(this.larger) + " \u2192 " + this.factor + "x " + String.valueOf(this.smaller);
        }
    }
}

