/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.misc;

import appeng.api.stacks.AEItemKey;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;

public class CompressionChain {
    public static final StreamCodec<RegistryFriendlyByteBuf, CompressionChain> STREAM_CODEC = Variant.STREAM_CODEC.apply(ByteBufCodecs.list()).map(CompressionChain::new, chain -> chain.variants);
    private final List<Variant> variants;

    CompressionChain(List<Variant> variants) {
        this.variants = Collections.unmodifiableList(variants);
    }

    public boolean isEmpty() {
        return this.variants.isEmpty();
    }

    public boolean containsVariant(Item item) {
        for (Variant variant : this.variants) {
            if (!variant.item.equals(item)) continue;
            return true;
        }
        return false;
    }

    public Item getCutoffItem(int cutoff) {
        return this.variants.get((int)(cutoff - 1)).item;
    }

    public BigInteger unitFactor(AEItemKey item) {
        if (item == null) {
            return BigInteger.ONE;
        }
        for (Variant variant : this.variants) {
            if (!variant.item.equals(item.getItem())) continue;
            return this.limited(this.variants.indexOf(variant) + 1).stream().map(v -> BigInteger.valueOf(v.factor)).reduce(BigInteger.ONE, BigInteger::multiply);
        }
        return BigInteger.ONE;
    }

    public List<Variant> limited(int limit) {
        return this.variants.subList(0, limit);
    }

    public List<Variant> trailing(int start) {
        return this.variants.subList(start, this.variants.size());
    }

    public int size() {
        return this.variants.size();
    }

    public List<Variant> lastMultiplierSwapped(int cutoff) {
        List<Variant> subChain = this.limited(cutoff);
        List multipliers = subChain.stream().map(Variant::factor).collect(Collectors.toList());
        Collections.rotate(multipliers, -1);
        List<Item> items = subChain.stream().map(Variant::item).toList();
        ObjectArrayList swapped = new ObjectArrayList();
        for (int i = 0; i < items.size(); ++i) {
            swapped.add((Object)new Variant(items.get(i), (Integer)multipliers.get(i)));
        }
        return Collections.unmodifiableList(swapped);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof CompressionChain)) return false;
        CompressionChain chain = (CompressionChain)o;
        if (!this.variants.equals(chain.variants)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hashCode(this.variants);
    }

    public record Variant(Item item, int factor) {
        public static final StreamCodec<RegistryFriendlyByteBuf, Variant> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ITEM), Variant::item, (StreamCodec)ByteBufCodecs.VAR_INT, Variant::factor, Variant::new);

        @Override
        public String toString() {
            return this.factor + "x \u2192 " + String.valueOf(this.item);
        }
    }
}

