/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.menu;

import appeng.api.config.CopyMode;
import appeng.api.config.FuzzyMode;
import appeng.api.config.Settings;
import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.ICellWorkbenchItem;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.util.IConfigManager;
import appeng.helpers.externalstorage.GenericStackInv;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.UpgradeableMenu;
import appeng.menu.slot.CellPartitionSlot;
import appeng.menu.slot.IOptionalSlotHost;
import appeng.menu.slot.IPartitionSlotHost;
import appeng.menu.slot.OptionalRestrictedInputSlot;
import appeng.menu.slot.RestrictedInputSlot;
import appeng.util.ConfigMenuInventory;
import appeng.util.EnumCycler;
import appeng.util.inv.SupplierInternalInventory;
import com.google.common.collect.Iterators;
import gripe._90.megacells.definition.MEGAMenus;
import gripe._90.megacells.item.cell.BulkCellInventory;
import gripe._90.megacells.item.cell.BulkCellItem;
import gripe._90.megacells.item.cell.PortableCellWorkbenchMenuHost;
import gripe._90.megacells.menu.CompressionCutoffHost;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class PortableCellWorkbenchMenu
extends UpgradeableMenu<PortableCellWorkbenchMenuHost>
implements IPartitionSlotHost,
CompressionCutoffHost {
    @GuiSync(value=2)
    public CopyMode copyMode = CopyMode.CLEAR_ON_REMOVE;

    public PortableCellWorkbenchMenu(int id, Inventory ip, PortableCellWorkbenchMenuHost host) {
        super(MEGAMenus.PORTABLE_CELL_WORKBENCH.get(), id, ip, (IUpgradeableObject)host);
        this.registerClientAction("nextCopyMode", this::nextWorkBenchCopyMode);
        this.registerClientAction("partition", this::partition);
        this.registerClientAction("clear", this::clear);
        this.registerClientAction("setFuzzyMode", FuzzyMode.class, this::setCellFuzzyMode);
        this.registerClientAction("openCompressionLimitMenu", Boolean.class, this::mega$nextCompressionLimit);
    }

    public void setCellFuzzyMode(FuzzyMode fuzzyMode) {
        if (this.isClientSide()) {
            this.sendClientAction("setFuzzyMode", fuzzyMode);
        } else {
            ICellWorkbenchItem cell = ((PortableCellWorkbenchMenuHost)this.getHost()).getCell();
            if (cell != null) {
                cell.setFuzzyMode(this.getWorkbenchItem(), fuzzyMode);
                ((PortableCellWorkbenchMenuHost)this.getHost()).saveChanges();
            }
        }
    }

    public void nextWorkBenchCopyMode() {
        if (this.isClientSide()) {
            this.sendClientAction("nextCopyMode");
        } else {
            ((PortableCellWorkbenchMenuHost)this.getHost()).getConfigManager().putSetting(Settings.COPY_MODE, (Enum)((CopyMode)EnumCycler.next((Enum)this.getWorkBenchCopyMode())));
        }
    }

    @Override
    public void mega$nextCompressionLimit(boolean backwards) {
        if (this.isClientSide()) {
            this.sendClientAction("openCompressionLimitMenu", backwards);
        } else {
            BulkCellInventory bulkCellInventory = BulkCellItem.HANDLER.getCellInventory(((PortableCellWorkbenchMenuHost)this.getHost()).mega$getContainedStack(), null);
            if (bulkCellInventory instanceof BulkCellInventory) {
                BulkCellInventory bulkCell = bulkCellInventory;
                int limit = bulkCell.getCompressionCutoff();
                limit = backwards ? (limit == bulkCell.getCompressionChain().size() ? 1 : limit + 1) : (limit == 1 ? bulkCell.getCompressionChain().size() : limit - 1);
                bulkCell.setCompressionCutoff(limit);
                ((PortableCellWorkbenchMenuHost)this.getHost()).saveChanges();
            }
        }
    }

    private CopyMode getWorkBenchCopyMode() {
        return (CopyMode)((PortableCellWorkbenchMenuHost)this.getHost()).getConfigManager().getSetting(Settings.COPY_MODE);
    }

    protected void setupInventorySlots() {
        InternalInventory cell = ((PortableCellWorkbenchMenuHost)this.getHost()).getSubInventory(ISegmentedInventory.CELLS);
        this.addSlot((Slot)new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.WORKBENCH_CELL, cell, 0), SlotSemantics.STORAGE_CELL);
    }

    protected void setupConfig() {
        ConfigMenuInventory inv = this.getConfigInventory().createMenuWrapper();
        for (int slot = 0; slot < 63; ++slot) {
            this.addSlot((Slot)new CellPartitionSlot((InternalInventory)inv, (IPartitionSlotHost)this, slot), SlotSemantics.CONFIG);
        }
    }

    protected void setupUpgrades() {
        SupplierInternalInventory upgradeInventory = new SupplierInternalInventory(() -> ((PortableCellWorkbenchMenu)this).getUpgrades());
        for (int i = 0; i < 8; ++i) {
            OptionalRestrictedInputSlot slot = new OptionalRestrictedInputSlot(RestrictedInputSlot.PlacableItemType.UPGRADES, (InternalInventory)upgradeInventory, (IOptionalSlotHost)this, i, i, this.getPlayerInventory());
            this.addSlot((Slot)slot, SlotSemantics.UPGRADE);
        }
    }

    public ItemStack getWorkbenchItem() {
        return Objects.requireNonNull(((PortableCellWorkbenchMenuHost)this.getHost()).getSubInventory(ISegmentedInventory.CELLS)).getStackInSlot(0);
    }

    protected void loadSettingsFromHost(IConfigManager cm) {
        this.copyMode = this.getWorkBenchCopyMode();
        ICellWorkbenchItem cell = ((PortableCellWorkbenchMenuHost)this.getHost()).getCell();
        this.setFuzzyMode(cell != null ? cell.getFuzzyMode(this.getWorkbenchItem()) : FuzzyMode.IGNORE_ALL);
    }

    public boolean isSlotEnabled(int idx) {
        return idx < this.getUpgrades().size();
    }

    public boolean isPartitionSlotEnabled(int idx) {
        ICellWorkbenchItem cell = ((PortableCellWorkbenchMenuHost)this.getHost()).getCell();
        if (cell != null && this.getCopyMode() == CopyMode.CLEAR_ON_REMOVE) {
            return idx < cell.getConfigInventory(this.getWorkbenchItem()).size();
        }
        return this.getCopyMode() == CopyMode.KEEP_ON_REMOVE;
    }

    public void onServerDataSync(ShortSet updatedFields) {
        super.onServerDataSync(updatedFields);
        ((PortableCellWorkbenchMenuHost)this.getHost()).getConfigManager().putSetting(Settings.COPY_MODE, (Enum)this.getCopyMode());
    }

    public void clear() {
        if (this.isClientSide()) {
            this.sendClientAction("clear");
        } else {
            this.getConfigInventory().clear();
            this.broadcastChanges();
        }
    }

    public void partition() {
        if (this.isClientSide()) {
            this.sendClientAction("partition");
        } else {
            GenericStackInv inv = this.getConfigInventory();
            ItemStack is = this.getWorkbenchItem();
            StorageCell cellInv = StorageCells.getCellInventory((ItemStack)is, null);
            if (cellInv != null) {
                Iterator it = Iterators.transform((Iterator)cellInv.getAvailableStacks().iterator(), Map.Entry::getKey);
                for (int x = 0; x < inv.size(); ++x) {
                    if (it.hasNext()) {
                        inv.setStack(x, new GenericStack((AEKey)it.next(), 0L));
                        continue;
                    }
                    inv.setStack(x, null);
                }
            }
            this.broadcastChanges();
        }
    }

    private GenericStackInv getConfigInventory() {
        return Objects.requireNonNull(((PortableCellWorkbenchMenuHost)this.getHost()).getConfig());
    }

    public CopyMode getCopyMode() {
        return this.copyMode;
    }
}

