/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.item.cell;

import appeng.api.config.Actionable;
import appeng.api.crafting.IPatternDetails;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import gripe._90.megacells.definition.MEGAComponents;
import gripe._90.megacells.definition.MEGAItems;
import gripe._90.megacells.item.cell.BulkCellItem;
import gripe._90.megacells.misc.CompressionChain;
import gripe._90.megacells.misc.CompressionService;
import gripe._90.megacells.misc.DecompressionPattern;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.SequencedCollection;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class BulkCellInventory
implements StorageCell {
    public static final long STACK_LIMIT = (long)Math.pow(2.0, 42.0);
    private final ISaveProvider container;
    private final ItemStack stack;
    private AEItemKey storedItem;
    private final AEItemKey filterItem;
    private final boolean compressionEnabled;
    private final CompressionChain compressionChain;
    private BigInteger unitCount;
    private final BigInteger unitFactor;
    private final int compressionCutoff;
    private Set<IPatternDetails> decompressionPatterns;
    private boolean isPersisted = true;

    BulkCellInventory(ItemStack stack, ISaveProvider container) {
        int recordedCutoff;
        this.stack = stack;
        this.container = container;
        BulkCellItem cell = (BulkCellItem)stack.getItem();
        this.filterItem = (AEItemKey)cell.getConfigInventory(stack).getKey(0);
        this.storedItem = (AEItemKey)stack.get(MEGAComponents.BULK_CELL_ITEM);
        this.unitCount = (BigInteger)stack.getOrDefault(MEGAComponents.BULK_CELL_UNIT_COUNT, (Object)BigInteger.ZERO);
        this.compressionEnabled = cell.getUpgrades(stack).isInstalled(MEGAItems.COMPRESSION_CARD);
        this.compressionChain = CompressionService.getChain(this.storedItem != null ? this.storedItem : this.filterItem);
        this.unitFactor = this.compressionChain.unitFactor(this.storedItem != null ? this.storedItem : this.filterItem);
        BigInteger recordedFactor = (BigInteger)stack.getOrDefault(MEGAComponents.BULK_CELL_UNIT_FACTOR, (Object)this.unitFactor);
        if (!this.unitFactor.equals(recordedFactor)) {
            this.unitCount = this.unitCount.multiply(this.unitFactor).divide(recordedFactor);
            this.saveChanges();
        }
        if ((recordedCutoff = ((Integer)stack.getOrDefault(MEGAComponents.BULK_CELL_COMPRESSION_CUTOFF, (Object)this.compressionChain.size())).intValue()) > this.compressionChain.size()) {
            stack.remove(MEGAComponents.BULK_CELL_COMPRESSION_CUTOFF);
            this.compressionCutoff = this.compressionChain.size();
        } else {
            this.compressionCutoff = recordedCutoff;
        }
    }

    private long clampedLong(BigInteger toClamp, long limit) {
        return toClamp.min(BigInteger.valueOf(limit)).longValue();
    }

    public CellState getStatus() {
        if (this.storedItem == null || this.unitCount.signum() < 1) {
            return CellState.EMPTY;
        }
        if (!this.storedItem.equals((Object)this.filterItem)) {
            return CellState.FULL;
        }
        return CellState.NOT_EMPTY;
    }

    public AEItemKey getStoredItem() {
        return this.storedItem;
    }

    public long getStoredQuantity() {
        return this.clampedLong(this.unitCount.divide(this.unitFactor), Long.MAX_VALUE);
    }

    public AEItemKey getFilterItem() {
        return this.filterItem;
    }

    public boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    public CompressionChain getCompressionChain() {
        return this.compressionChain;
    }

    public Set<IPatternDetails> getDecompressionPatterns() {
        if (!this.compressionEnabled || this.compressionChain.isEmpty()) {
            return Set.of();
        }
        if (this.decompressionPatterns == null) {
            SequencedCollection decompressionChain = this.compressionChain.limited(this.compressionCutoff).reversed();
            this.decompressionPatterns = new ObjectLinkedOpenHashSet();
            for (CompressionChain.Variant variant : decompressionChain) {
                if (variant == decompressionChain.getLast()) continue;
                CompressionChain.Variant decompressed = (CompressionChain.Variant)decompressionChain.get(decompressionChain.indexOf(variant) + 1);
                this.decompressionPatterns.add(new DecompressionPattern(decompressed.item(), variant, false));
            }
            List<CompressionChain.Variant> remainingChain = this.compressionChain.trailing(decompressionChain.size() - 1);
            for (CompressionChain.Variant variant : remainingChain) {
                if (variant == remainingChain.getFirst()) continue;
                CompressionChain.Variant decompressed = remainingChain.get(remainingChain.indexOf(variant) - 1);
                this.decompressionPatterns.add(new DecompressionPattern(decompressed.item(), variant, true));
            }
        }
        return Collections.unmodifiableSet(this.decompressionPatterns);
    }

    public double getIdleDrain() {
        return 5.0;
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (amount == 0L || !(what instanceof AEItemKey)) {
            return 0L;
        }
        AEItemKey item = (AEItemKey)what;
        if (this.filterItem == null || this.storedItem != null && !this.filterItem.equals((Object)this.storedItem)) {
            return 0L;
        }
        if (!this.compressionEnabled && !what.equals(this.filterItem)) {
            return 0L;
        }
        if (this.compressionEnabled && !what.equals(this.filterItem) && !this.compressionChain.containsVariant(item.getItem())) {
            return 0L;
        }
        BigInteger factor = this.compressionChain.unitFactor(item);
        BigInteger units = BigInteger.valueOf(amount).multiply(factor);
        if (mode == Actionable.MODULATE) {
            if (this.storedItem == null) {
                this.storedItem = this.filterItem;
            }
            this.unitCount = this.unitCount.add(units);
            this.saveChanges();
        }
        return amount;
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (this.unitCount.signum() < 1 || !(what instanceof AEItemKey)) {
            return 0L;
        }
        AEItemKey item = (AEItemKey)what;
        if (this.filterItem == null || this.storedItem != null && !this.filterItem.equals((Object)this.storedItem)) {
            return 0L;
        }
        if (!(this.compressionEnabled || this.unitCount.divide(this.unitFactor).signum() >= 1 && what.equals(this.storedItem))) {
            return 0L;
        }
        if (this.compressionEnabled && !what.equals(this.filterItem) && !this.compressionChain.containsVariant(item.getItem())) {
            return 0L;
        }
        BigInteger factor = this.compressionChain.unitFactor(item);
        BigInteger currentUnitCount = this.unitCount;
        BigInteger units = BigInteger.valueOf(amount).multiply(factor);
        if (currentUnitCount.compareTo(units) <= 0) {
            if (mode == Actionable.MODULATE) {
                this.storedItem = null;
                this.unitCount = BigInteger.ZERO;
                this.saveChanges();
            }
            return this.clampedLong(currentUnitCount.divide(factor), Long.MAX_VALUE);
        }
        if (mode == Actionable.MODULATE) {
            this.unitCount = this.unitCount.subtract(units);
            this.saveChanges();
        }
        return this.clampedLong(units.divide(factor), Long.MAX_VALUE);
    }

    private void saveChanges() {
        this.isPersisted = false;
        if (this.container != null) {
            this.container.saveChanges();
        } else {
            this.persist();
        }
    }

    public void persist() {
        if (this.isPersisted) {
            return;
        }
        if (this.storedItem == null || this.unitCount.signum() < 1) {
            this.stack.remove(MEGAComponents.BULK_CELL_ITEM);
            this.stack.remove(MEGAComponents.BULK_CELL_UNIT_COUNT);
            this.stack.remove(MEGAComponents.BULK_CELL_UNIT_FACTOR);
        } else {
            this.stack.set(MEGAComponents.BULK_CELL_ITEM, (Object)this.storedItem);
            this.stack.set(MEGAComponents.BULK_CELL_UNIT_COUNT, (Object)this.unitCount);
            this.stack.set(MEGAComponents.BULK_CELL_UNIT_FACTOR, (Object)this.unitFactor);
        }
        this.isPersisted = true;
    }

    public void setCompressionCutoff(int cutoff) {
        if (cutoff == this.compressionChain.size()) {
            this.stack.remove(MEGAComponents.BULK_CELL_COMPRESSION_CUTOFF);
        } else {
            this.stack.set(MEGAComponents.BULK_CELL_COMPRESSION_CUTOFF, (Object)cutoff);
        }
    }

    public int getCompressionCutoff() {
        return this.compressionCutoff;
    }

    public Item getCutoffItem() {
        return this.compressionChain.getCutoffItem(this.compressionCutoff);
    }

    public void getAvailableStacks(KeyCounter out) {
        if (this.storedItem != null) {
            if (this.compressionEnabled && this.storedItem.equals((Object)this.filterItem) && !this.compressionChain.isEmpty()) {
                BigInteger count = this.unitCount;
                List<CompressionChain.Variant> chain = this.compressionChain.lastMultiplierSwapped(this.compressionCutoff);
                for (CompressionChain.Variant variant : chain) {
                    BigInteger compressionFactor = BigInteger.valueOf(variant.factor());
                    AEItemKey key = AEItemKey.of((ItemLike)variant.item());
                    if (count.divide(compressionFactor).signum() == 1 && variant != chain.getLast()) {
                        out.add((AEKey)key, count.remainder(compressionFactor).longValue());
                        count = count.divide(compressionFactor);
                        continue;
                    }
                    out.add((AEKey)key, this.clampedLong(count, STACK_LIMIT));
                    break;
                }
            } else {
                out.add((AEKey)this.storedItem, this.clampedLong(this.unitCount.divide(this.unitFactor), STACK_LIMIT));
            }
        }
    }

    public boolean isPreferredStorageFor(AEKey what, IActionSource source) {
        AEItemKey item;
        return what instanceof AEItemKey && ((item = (AEItemKey)what).equals((Object)this.storedItem) || item.equals((Object)this.filterItem) || this.compressionChain.containsVariant(item.getItem()));
    }

    public boolean canFitInsideCell() {
        return this.filterItem == null && this.storedItem == null && this.unitCount.signum() < 1;
    }

    public Component getDescription() {
        return this.stack.getHoverName();
    }
}

