/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.integration.appmek;

import appeng.api.stacks.AEKey;
import appeng.api.upgrades.Upgrades;
import appeng.core.definitions.AEItems;
import appeng.core.localization.GuiText;
import appeng.items.storage.StorageTier;
import gripe._90.megacells.definition.MEGAItems;
import gripe._90.megacells.integration.IntegrationHelper;
import gripe._90.megacells.item.cell.MEGAPortableCell;
import java.util.List;
import java.util.function.Function;
import me.ramidzkh.mekae2.AMItems;
import me.ramidzkh.mekae2.AMMenus;
import me.ramidzkh.mekae2.ae2.MekanismKey;
import me.ramidzkh.mekae2.ae2.MekanismKeyType;
import me.ramidzkh.mekae2.item.ChemicalStorageCell;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredItem;

public class AppMekIntegration
implements IntegrationHelper {
    @Override
    public Function<Item.Properties, Item> createCell(StorageTier tier) {
        return p -> new ChemicalStorageCell(p, tier);
    }

    @Override
    public Function<Item.Properties, Item> createPortable(StorageTier tier) {
        return p -> new MEGAPortableCell(this, (Item.Properties)p, tier, MekanismKeyType.TYPE, AMMenus.PORTABLE_CHEMICAL_CELL_TYPE, 8440575){

            public boolean isBlackListed(ItemStack cellItem, AEKey requestedAddition) {
                MekanismKey key;
                return !(requestedAddition instanceof MekanismKey) || !ChemicalAttributeValidator.DEFAULT.process((key = (MekanismKey)requestedAddition).getStack());
            }
        };
    }

    @Override
    public void initUpgrades() {
        String storageCellGroup = GuiText.StorageCells.getTranslationKey();
        String portableCellGroup = GuiText.PortableCells.getTranslationKey();
        for (MEGAItems.CellDefinition cell : MEGAItems.getTieredCells()) {
            if (!cell.keyType().equals("chemical")) continue;
            Upgrades.add((ItemLike)AEItems.INVERTER_CARD, cell.item(), (int)1, (String)storageCellGroup);
            Upgrades.add((ItemLike)AEItems.EQUAL_DISTRIBUTION_CARD, cell.item(), (int)1, (String)storageCellGroup);
            Upgrades.add((ItemLike)AEItems.VOID_CARD, cell.item(), (int)1, (String)storageCellGroup);
            if (!cell.portable()) continue;
            Upgrades.add(MEGAItems.GREATER_ENERGY_CARD, cell.item(), (int)2, (String)portableCellGroup);
        }
        for (DeferredItem portable : List.of(AMItems.PORTABLE_CHEMICAL_CELL_1K, AMItems.PORTABLE_CHEMICAL_CELL_4K, AMItems.PORTABLE_CHEMICAL_CELL_16K, AMItems.PORTABLE_CHEMICAL_CELL_64K, AMItems.PORTABLE_CHEMICAL_CELL_256K)) {
            Upgrades.add(MEGAItems.GREATER_ENERGY_CARD, (ItemLike)((ItemLike)portable.get()), (int)2, (String)portableCellGroup);
        }
    }
}

