/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.client.screen;

import appeng.api.config.ActionItems;
import appeng.api.config.CopyMode;
import appeng.api.config.FuzzyMode;
import appeng.api.config.Settings;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.AEKeySlotFilter;
import appeng.client.gui.Icon;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ActionButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.client.gui.widgets.ToggleButton;
import appeng.core.definitions.AEItems;
import appeng.core.localization.GuiText;
import appeng.menu.implementations.UpgradeableMenu;
import appeng.util.ConfigInventory;
import gripe._90.megacells.client.screen.CompressionCutoffButton;
import gripe._90.megacells.item.cell.BulkCellInventory;
import gripe._90.megacells.item.cell.BulkCellItem;
import gripe._90.megacells.item.cell.PortableCellWorkbenchMenuHost;
import gripe._90.megacells.menu.PortableCellWorkbenchMenu;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class PortableCellWorkbenchScreen
extends UpgradeableScreen<PortableCellWorkbenchMenu> {
    private final ToggleButton copyMode;
    private final SettingToggleButton<FuzzyMode> fuzzyMode = (SettingToggleButton)this.addToLeftToolbar((Button)new SettingToggleButton(Settings.FUZZY_MODE, (Enum)FuzzyMode.IGNORE_ALL, (button, backwards) -> menu.setCellFuzzyMode((FuzzyMode)button.getNextValue(backwards))));
    private final CompressionCutoffButton compressionCutoff;

    public PortableCellWorkbenchScreen(PortableCellWorkbenchMenu menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((UpgradeableMenu)menu, playerInventory, title, style);
        this.addToLeftToolbar((Button)new ActionButton(ActionItems.COG, act -> menu.partition()));
        this.addToLeftToolbar((Button)new ActionButton(ActionItems.CLOSE, act -> menu.clear()));
        this.copyMode = (ToggleButton)this.addToLeftToolbar((Button)new ToggleButton(Icon.COPY_MODE_ON, Icon.COPY_MODE_OFF, (Component)GuiText.CopyMode.text(), (Component)GuiText.CopyModeDesc.text(), act -> menu.nextWorkBenchCopyMode()));
        this.compressionCutoff = (CompressionCutoffButton)this.addToLeftToolbar((Button)new CompressionCutoffButton((button, backwards) -> menu.mega$nextCompressionLimit(backwards)));
    }

    protected void updateBeforeRender() {
        BulkCellInventory bulkCell;
        super.updateBeforeRender();
        this.copyMode.setState(((PortableCellWorkbenchMenu)this.menu).getCopyMode() == CopyMode.CLEAR_ON_REMOVE);
        this.fuzzyMode.set((Enum)((PortableCellWorkbenchMenu)this.menu).getFuzzyMode());
        this.fuzzyMode.setVisibility(((PortableCellWorkbenchMenu)this.menu).getUpgrades().isInstalled((ItemLike)AEItems.FUZZY_CARD));
        BulkCellInventory bulkCellInventory = BulkCellItem.HANDLER.getCellInventory(((PortableCellWorkbenchMenuHost)((PortableCellWorkbenchMenu)this.menu).getHost()).mega$getContainedStack(), null);
        if (bulkCellInventory instanceof BulkCellInventory && !(bulkCell = bulkCellInventory).getCompressionChain().isEmpty()) {
            this.compressionCutoff.setVisibility(bulkCell.isCompressionEnabled());
            this.compressionCutoff.setItem(bulkCell.getCutoffItem());
        } else {
            this.compressionCutoff.setVisibility(false);
        }
    }

    @NotNull
    protected List<Component> getTooltipFromContainerItem(@NotNull ItemStack stack) {
        AEKey what;
        ItemStack cell = ((PortableCellWorkbenchMenu)this.getMenu()).getWorkbenchItem();
        if (cell.isEmpty()) {
            return super.getTooltipFromContainerItem(stack);
        }
        if (cell == stack) {
            return super.getTooltipFromContainerItem(stack);
        }
        GenericStack genericStack = GenericStack.unwrapItemStack((ItemStack)stack);
        Object object = what = genericStack != null ? genericStack.what() : AEItemKey.of((ItemStack)stack);
        if (what == null) {
            return super.getTooltipFromContainerItem(stack);
        }
        ConfigInventory configInventory = ((PortableCellWorkbenchMenuHost)((PortableCellWorkbenchMenu)this.getMenu()).getHost()).getCell().getConfigInventory(cell);
        if (!configInventory.isSupportedType(what.getType())) {
            ArrayList<Component> lines = new ArrayList<Component>(super.getTooltipFromContainerItem(stack));
            lines.add((Component)GuiText.IncompatibleWithCell.text().withStyle(ChatFormatting.RED));
            return lines;
        }
        AEKeySlotFilter filter = configInventory.getFilter();
        if (filter != null) {
            boolean anySlotMatches = false;
            for (int i = 0; i < configInventory.size(); ++i) {
                if (!configInventory.isAllowedIn(i, what)) continue;
                anySlotMatches = true;
                break;
            }
            if (!anySlotMatches) {
                ArrayList<Component> lines = new ArrayList<Component>(super.getTooltipFromContainerItem(stack));
                lines.add((Component)GuiText.IncompatibleWithCell.text().withStyle(ChatFormatting.RED));
                return lines;
            }
        }
        return super.getTooltipFromContainerItem(stack);
    }
}

