/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.tileentity;

import com.blakebr0.cucumber.energy.DynamicEnergyStorage;
import com.blakebr0.cucumber.helper.CropHelper;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.inventory.OnContentsChangedFunction;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.mysticalagriculture.block.HarvesterBlock;
import com.blakebr0.mysticalagriculture.container.HarvesterContainer;
import com.blakebr0.mysticalagriculture.container.inventory.UpgradeItemStackHandler;
import com.blakebr0.mysticalagriculture.init.ModTileEntities;
import com.blakebr0.mysticalagriculture.util.IUpgradeableMachine;
import com.blakebr0.mysticalagriculture.util.MachineUpgradeTier;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class HarvesterTileEntity
extends BaseInventoryTileEntity
implements MenuProvider,
IUpgradeableMachine {
    private static final int FUEL_TICK_MULTIPLIER = 20;
    public static final int OPERATION_TIME = 100;
    public static final int FUEL_USAGE = 40;
    public static final int SCAN_FUEL_USAGE = 10;
    public static final int FUEL_CAPACITY = 80000;
    public static final int BASE_RANGE = 1;
    private final BaseItemStackHandler inventory = HarvesterTileEntity.createInventoryHandler(slot -> this.setChangedFast());
    private final UpgradeItemStackHandler upgradeInventory = new UpgradeItemStackHandler();
    private final DynamicEnergyStorage energy = new DynamicEnergyStorage(80000, () -> ((HarvesterTileEntity)this).setChangedFast());
    private MachineUpgradeTier tier;
    private Direction direction;
    private int progress;
    private int fuelLeft;
    private int fuelItemValue;
    private int lastScanIndex = -1;
    private boolean isRunning;

    public HarvesterTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.HARVESTER.get(), pos, state);
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public Component getDisplayName() {
        return Localizable.of((String)"container.mysticalagriculture.harvester").build();
    }

    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return HarvesterContainer.create(i, inventory, this.inventory, this.upgradeInventory, this.getBlockPos());
    }

    @Override
    public UpgradeItemStackHandler getUpgradeInventory() {
        return this.upgradeInventory;
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.loadAdditional(tag, lookup);
        this.progress = tag.getInt("Progress");
        this.fuelLeft = tag.getInt("FuelLeft");
        this.fuelItemValue = tag.getInt("FuelItemValue");
        this.lastScanIndex = tag.getInt("LastScanIndex");
        this.energy.deserializeNBT(lookup, tag.get("Energy"));
        this.upgradeInventory.deserializeNBT(lookup, tag.getCompound("UpgradeInventory"));
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.saveAdditional(tag, lookup);
        tag.putInt("Progress", this.progress);
        tag.putInt("FuelLeft", this.fuelLeft);
        tag.putInt("FuelItemValue", this.fuelItemValue);
        tag.putInt("LastScanIndex", this.lastScanIndex);
        tag.putInt("Energy", this.energy.getEnergyStored());
        tag.put("UpgradeInventory", (Tag)this.upgradeInventory.serializeNBT(lookup));
    }

    public static void tick(Level level, BlockPos pos, BlockState state, HarvesterTileEntity tile) {
        if (tile.energy.getEnergyStored() < tile.energy.getMaxEnergyStored()) {
            ItemStack fuel = tile.inventory.getStackInSlot(0);
            if (tile.fuelLeft <= 0 && !fuel.isEmpty()) {
                tile.fuelItemValue = fuel.getBurnTime(null);
                if (tile.fuelItemValue > 0) {
                    tile.fuelLeft = tile.fuelItemValue *= 20;
                    tile.inventory.setStackInSlot(0, StackHelper.shrink((ItemStack)fuel, (int)1, (boolean)true));
                    tile.setChangedFast();
                }
            }
            if (tile.fuelLeft > 0) {
                int fuelPerTick = Math.min(Math.min(tile.fuelLeft, tile.getFuelUsage() * 2), tile.energy.getMaxEnergyStored() - tile.energy.getEnergyStored());
                tile.fuelLeft -= tile.energy.receiveEnergy(fuelPerTick, false);
                if (tile.fuelLeft <= 0) {
                    tile.fuelItemValue = 0;
                }
                tile.setChangedFast();
            }
        }
        MachineUpgradeTier tier = tile.getMachineTier();
        Direction direction = (Direction)state.getValue((Property)HarvesterBlock.FACING);
        if (tier != tile.tier || direction != tile.direction) {
            tile.tier = tier;
            tile.direction = direction;
            if (tier == null) {
                tile.energy.resetMaxEnergyStorage();
            } else {
                tile.energy.setMaxEnergyStorage((int)(80000.0 * tier.getFuelCapacityMultiplier()));
            }
            tile.setChangedFast();
        }
        boolean isDisabled = level.hasNeighborSignal(tile.getBlockPos());
        int operationTime = tile.getOperationTime();
        if (tile.progress > operationTime && !isDisabled) {
            BlockPos nextPos = tile.findNextPosition();
            BlockState cropState = level.getBlockState(nextPos);
            Block block = cropState.getBlock();
            if (block instanceof CropBlock) {
                CropBlock crop = (CropBlock)block;
                Item seed = CropHelper.getSeedsItem((Block)block);
                if (seed != null && crop.isMaxAge(cropState)) {
                    List drops = Block.getDrops((BlockState)cropState, (ServerLevel)((ServerLevel)level), (BlockPos)nextPos, (BlockEntity)tile);
                    for (ItemStack drop : drops) {
                        Item item = drop.getItem();
                        if (drop.isEmpty() || item != seed) continue;
                        drop.shrink(1);
                        break;
                    }
                    for (ItemStack drop : drops) {
                        if (drop.isEmpty()) continue;
                        tile.addItemToInventory(drop, level, nextPos);
                    }
                    level.setBlockAndUpdate(nextPos, crop.getStateForAge(0));
                    tile.energy.extractEnergy(tile.getFuelUsage(), false);
                } else {
                    tile.energy.extractEnergy(10, false);
                }
            }
            tile.progress = 0;
            tile.setChangedFast();
        }
        boolean wasRunning = tile.isRunning;
        if (!isDisabled && tile.energy.getEnergyStored() >= tile.getFuelUsage()) {
            ++tile.progress;
            tile.isRunning = true;
            tile.setChangedFast();
        } else {
            tile.isRunning = false;
        }
        if (wasRunning != tile.isRunning) {
            level.setBlock(pos, (BlockState)state.setValue((Property)HarvesterBlock.RUNNING, (Comparable)Boolean.valueOf(tile.isRunning)), 3);
            tile.setChangedFast();
        }
        tile.dispatchIfChanged();
    }

    public static BaseItemStackHandler createInventoryHandler() {
        return HarvesterTileEntity.createInventoryHandler(null);
    }

    public static BaseItemStackHandler createInventoryHandler(OnContentsChangedFunction onContentsChanged) {
        return BaseItemStackHandler.create((int)16, (OnContentsChangedFunction)onContentsChanged, builder -> {
            builder.setCanInsert((slot, stack) -> slot == 0 && stack.getBurnTime(null) > 0);
            builder.setCanExtract(slot -> slot > 0);
        });
    }

    public DynamicEnergyStorage getEnergy() {
        return this.energy;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getOperationTime() {
        if (this.tier == null) {
            return 100;
        }
        return (int)(100.0 * this.tier.getOperationTimeMultiplier());
    }

    public int getFuelLeft() {
        return this.fuelLeft;
    }

    public int getFuelItemValue() {
        return this.fuelItemValue;
    }

    public int getFuelUsage() {
        if (this.tier == null) {
            return 40;
        }
        return (int)(40.0 * this.tier.getFuelUsageMultiplier());
    }

    private BlockPos findNextPosition() {
        int index = this.lastScanIndex + 1;
        int range = this.tier != null ? 1 + this.tier.getAddedRange() : 1;
        int size = range * 2 + 1;
        if (index >= (int)Math.pow(size, 2.0)) {
            index = 0;
        }
        this.lastScanIndex = index;
        int xOffset = index % size - range;
        int zOffset = index / size - range;
        BlockPos center = this.getBlockPos().relative(this.direction, range + 1);
        return switch (this.direction) {
            case Direction.NORTH -> new BlockPos(center.getX() + xOffset, center.getY(), center.getZ() - zOffset);
            case Direction.SOUTH -> new BlockPos(center.getX() - xOffset, center.getY(), center.getZ() + zOffset);
            case Direction.EAST -> new BlockPos(center.getX() + zOffset, center.getY(), center.getZ() + xOffset);
            case Direction.WEST -> new BlockPos(center.getX() - zOffset, center.getY(), center.getZ() - xOffset);
            default -> center;
        };
    }

    private void addItemToInventory(ItemStack stack, Level level, BlockPos pos) {
        int remaining = stack.getCount();
        for (int i = 1; i < this.inventory.getSlots(); ++i) {
            ItemStack stackInSlot = this.inventory.getStackInSlot(i);
            if (stackInSlot.isEmpty()) {
                this.inventory.setStackInSlot(i, stack.copy());
                return;
            }
            if (StackHelper.areStacksEqual((ItemStack)stackInSlot, (ItemStack)stack)) {
                int insertSize = Math.min(remaining, stackInSlot.getMaxStackSize() - stackInSlot.getCount());
                this.inventory.setStackInSlot(i, StackHelper.grow((ItemStack)stackInSlot, (int)insertSize));
                remaining -= insertSize;
            }
            if (remaining != 0) continue;
            return;
        }
        Block.popResource((Level)level, (BlockPos)pos, (ItemStack)StackHelper.withSize((ItemStack)stack, (int)remaining, (boolean)false));
    }
}

