/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.lib;

import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.blakebr0.mysticalagriculture.api.registry.IMobSoulTypeRegistry;
import com.blakebr0.mysticalagriculture.api.soul.MobSoulType;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.ModList;

public final class ModMobSoulTypes {
    private static final boolean DEBUG = false;
    private static final Set<ResourceLocation> FISH_IDS = Sets.newHashSet((Object[])new ResourceLocation[]{ResourceLocation.parse((String)"minecraft:cod"), ResourceLocation.parse((String)"minecraft:salmon"), ResourceLocation.parse((String)"minecraft:tropical_fish"), ResourceLocation.parse((String)"minecraft:pufferfish")});
    private static final Set<ResourceLocation> SLIME_IDS = Sets.newHashSet((Object[])new ResourceLocation[]{ResourceLocation.parse((String)"minecraft:slime"), ResourceLocation.parse((String)"tconstruct:earth_slime")});
    private static final Set<ResourceLocation> ZOMBIE_IDS = Sets.newHashSet((Object[])new ResourceLocation[]{ResourceLocation.parse((String)"minecraft:zombie"), ResourceLocation.parse((String)"minecraft:zombie_villager"), ResourceLocation.parse((String)"minecraft:husk"), ResourceLocation.parse((String)"minecraft:drowned")});
    private static final Set<ResourceLocation> SKELETON_IDS = Sets.newHashSet((Object[])new ResourceLocation[]{ResourceLocation.parse((String)"minecraft:skeleton"), ResourceLocation.parse((String)"minecraft:stray")});
    private static final Set<ResourceLocation> SPIDER_IDS = Sets.newHashSet((Object[])new ResourceLocation[]{ResourceLocation.parse((String)"minecraft:spider"), ResourceLocation.parse((String)"minecraft:cave_spider")});
    public static final MobSoulType PIG = new MobSoulType(MysticalAgriculture.resource("pig"), ResourceLocation.parse((String)"minecraft:pig"), 8.0, 15771042);
    public static final MobSoulType CHICKEN = new MobSoulType(MysticalAgriculture.resource("chicken"), ResourceLocation.parse((String)"minecraft:chicken"), 8.0, 0xA1A1A1);
    public static final MobSoulType COW = new MobSoulType(MysticalAgriculture.resource("cow"), ResourceLocation.parse((String)"minecraft:cow"), 8.0, 4470310);
    public static final MobSoulType SHEEP = new MobSoulType(MysticalAgriculture.resource("sheep"), ResourceLocation.parse((String)"minecraft:sheep"), 8.0, 0xE7E7E7);
    public static final MobSoulType SQUID = new MobSoulType(MysticalAgriculture.resource("squid"), ResourceLocation.parse((String)"minecraft:squid"), 6.0, 2243405);
    public static final MobSoulType FISH = new MobSoulType(MysticalAgriculture.resource("fish"), FISH_IDS, "fish", 6.0, 12691306);
    public static final MobSoulType SLIME = new MobSoulType(MysticalAgriculture.resource("slime"), SLIME_IDS, "slime", 12.0, 5349438);
    public static final MobSoulType TURTLE = new MobSoulType(MysticalAgriculture.resource("turtle"), ResourceLocation.parse((String)"minecraft:turtle"), 6.0, 44975);
    public static final MobSoulType ARMADILLO = new MobSoulType(MysticalAgriculture.resource("armadillo"), ResourceLocation.parse((String)"minecraft:armadillo"), 6.0, 0xB67B76);
    public static final MobSoulType ZOMBIE = new MobSoulType(MysticalAgriculture.resource("zombie"), ZOMBIE_IDS, "zombie", 10.0, 7969893);
    public static final MobSoulType SKELETON = new MobSoulType(MysticalAgriculture.resource("skeleton"), SKELETON_IDS, "skeleton", 10.0, 0xC1C1C1);
    public static final MobSoulType CREEPER = new MobSoulType(MysticalAgriculture.resource("creeper"), ResourceLocation.parse((String)"minecraft:creeper"), 10.0, 894731);
    public static final MobSoulType SPIDER = new MobSoulType(MysticalAgriculture.resource("spider"), SPIDER_IDS, "spider", 10.0, 3419431);
    public static final MobSoulType RABBIT = new MobSoulType(MysticalAgriculture.resource("rabbit"), ResourceLocation.parse((String)"minecraft:rabbit"), 6.0, 10051392);
    public static final MobSoulType BREEZE = new MobSoulType(MysticalAgriculture.resource("breeze"), ResourceLocation.parse((String)"minecraft:breeze"), 4.0, 7963335);
    public static final MobSoulType BLAZE = new MobSoulType(MysticalAgriculture.resource("blaze"), ResourceLocation.parse((String)"minecraft:blaze"), 10.0, 16167425);
    public static final MobSoulType GHAST = new MobSoulType(MysticalAgriculture.resource("ghast"), ResourceLocation.parse((String)"minecraft:ghast"), 4.0, 0xF9F9F9);
    public static final MobSoulType ENDERMAN = new MobSoulType(MysticalAgriculture.resource("enderman"), ResourceLocation.parse((String)"minecraft:enderman"), 8.0, 0x161616);
    public static final MobSoulType WITHER = new MobSoulType(MysticalAgriculture.resource("wither_skeleton"), ResourceLocation.parse((String)"minecraft:wither_skeleton"), 8.0, 0x141414);
    public static final MobSoulType BLIZZ = new MobSoulType(MysticalAgriculture.resource("blizz"), ResourceLocation.parse((String)"thermal:blizz"), 6.0, 8115455);
    public static final MobSoulType BLITZ = new MobSoulType(MysticalAgriculture.resource("blitz"), ResourceLocation.parse((String)"thermal:blitz"), 6.0, 0xECFEFC);
    public static final MobSoulType BASALZ = new MobSoulType(MysticalAgriculture.resource("basalz"), ResourceLocation.parse((String)"thermal:basalz"), 6.0, 3553344);

    public static void onRegisterMobSoulTypes(IMobSoulTypeRegistry registry) {
        registry.register(PIG);
        registry.register(CHICKEN);
        registry.register(COW);
        registry.register(SHEEP);
        registry.register(SQUID);
        registry.register(FISH);
        registry.register(SLIME);
        registry.register(TURTLE);
        registry.register(ARMADILLO);
        registry.register(ZOMBIE);
        registry.register(SKELETON);
        registry.register(CREEPER);
        registry.register(SPIDER);
        registry.register(RABBIT);
        registry.register(BREEZE);
        registry.register(BLAZE);
        registry.register(GHAST);
        registry.register(ENDERMAN);
        registry.register(WITHER);
        registry.register(ModMobSoulTypes.withRequiredMods(BLIZZ, "thermal"));
        registry.register(ModMobSoulTypes.withRequiredMods(BLITZ, "thermal"));
        registry.register(ModMobSoulTypes.withRequiredMods(BASALZ, "thermal"));
    }

    private static MobSoulType withRequiredMods(MobSoulType type, String ... mods) {
        boolean enabled = Arrays.stream(mods).anyMatch(arg_0 -> ((ModList)ModList.get()).isLoaded(arg_0));
        return type.setEnabled(enabled);
    }
}

