/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting.ingredient;

import com.blakebr0.mysticalagriculture.api.util.MobSoulUtils;
import com.blakebr0.mysticalagriculture.init.ModIngredientTypes;
import com.blakebr0.mysticalagriculture.init.ModItems;
import com.blakebr0.mysticalagriculture.item.SoulJarItem;
import com.blakebr0.mysticalagriculture.registry.MobSoulTypeRegistry;
import com.mojang.serialization.MapCodec;
import java.util.stream.Stream;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import org.jetbrains.annotations.Nullable;

public class FilledSoulJarIngredient
implements ICustomIngredient {
    public static final MapCodec<FilledSoulJarIngredient> CODEC = MapCodec.unit(FilledSoulJarIngredient::new);
    private ItemStack[] stacks;

    public boolean test(@Nullable ItemStack stack) {
        if (stack != null) {
            if (this.stacks == null) {
                this.initMatchingStacks();
            }
            return stack.getItem() instanceof SoulJarItem && MobSoulUtils.getSouls(stack) > 0.0;
        }
        return false;
    }

    public Stream<ItemStack> getItems() {
        if (this.stacks == null) {
            this.initMatchingStacks();
        }
        return Stream.of(this.stacks);
    }

    public boolean isSimple() {
        return false;
    }

    public IngredientType<?> getType() {
        return (IngredientType)ModIngredientTypes.FILLED_SOUL_JAR.get();
    }

    private void initMatchingStacks() {
        this.stacks = (ItemStack[])MobSoulTypeRegistry.getInstance().getMobSoulTypes().stream().map(type -> MobSoulUtils.getFilledSoulJar(type, (Item)ModItems.SOUL_JAR.get())).toArray(ItemStack[]::new);
    }

    public static Ingredient of() {
        return new FilledSoulJarIngredient().toVanilla();
    }
}

