/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.block;

import com.blakebr0.cucumber.block.BaseTileEntityBlock;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.util.VoxelShapeBuilder;
import com.blakebr0.mysticalagriculture.tileentity.EssenceVesselTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EssenceVesselBlock
extends BaseTileEntityBlock {
    public static final VoxelShape VESSEL_SHAPE = VoxelShapeBuilder.fromShapes((VoxelShape[])new VoxelShape[]{Shapes.box((double)0.690625, (double)0.0, (double)0.1875, (double)0.815625, (double)0.125, (double)0.3125), Shapes.box((double)0.1875, (double)0.0, (double)0.1875, (double)0.3125, (double)0.125, (double)0.3125), Shapes.box((double)0.1875, (double)0.0, (double)0.6875, (double)0.3125, (double)0.125, (double)0.8125), Shapes.box((double)0.6875, (double)0.0, (double)0.6875, (double)0.8125, (double)0.125, (double)0.8125), Shapes.box((double)0.1875, (double)0.71875, (double)0.1875, (double)0.8125, (double)1.15625, (double)0.8125), Shapes.box((double)0.4375, (double)0.6875, (double)0.15625, (double)0.5625, (double)1.1875, (double)0.21875), Shapes.box((double)0.15625, (double)0.6875, (double)0.4375, (double)0.21875, (double)1.1875, (double)0.5625), Shapes.box((double)0.78125, (double)0.6875, (double)0.4375, (double)0.84375, (double)1.1875, (double)0.5625), Shapes.box((double)0.4375, (double)0.6875, (double)0.78125, (double)0.5625, (double)1.1875, (double)0.84375), Shapes.box((double)0.21875, (double)0.6875, (double)0.4375, (double)0.40625, (double)0.71875, (double)0.5625), Shapes.box((double)0.59375, (double)0.6875, (double)0.4375, (double)0.78125, (double)0.71875, (double)0.5625), Shapes.box((double)0.4375, (double)0.6875, (double)0.59375, (double)0.5625, (double)0.71875, (double)0.78125), Shapes.box((double)0.4375, (double)0.6875, (double)0.21875, (double)0.5625, (double)0.71875, (double)0.40625), Shapes.box((double)0.3125, (double)0.625, (double)0.3125, (double)0.6875, (double)0.6875, (double)0.6875), Shapes.box((double)0.375, (double)0.15625, (double)0.375, (double)0.625, (double)0.625, (double)0.625), Shapes.box((double)0.25, (double)0.125, (double)0.25, (double)0.75, (double)0.1875, (double)0.75)}).build();

    public EssenceVesselBlock() {
        super(SoundType.STONE, 10.0f, 12.0f, true);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new EssenceVesselTileEntity(pos, state);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity tile = level.getBlockEntity(pos);
        if (tile instanceof EssenceVesselTileEntity) {
            ItemStack remaining;
            EssenceVesselTileEntity vessel = (EssenceVesselTileEntity)tile;
            BaseItemStackHandler inventory = vessel.getInventory();
            ItemStack input = inventory.getStackInSlot(0);
            ItemStack held = player.getItemInHand(hand);
            if (held != (remaining = inventory.insertItem(0, held, false))) {
                player.setItemInHand(hand, remaining);
                level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (!input.isEmpty()) {
                inventory.setStackInSlot(0, ItemStack.EMPTY);
                ItemEntity item = new ItemEntity(level, player.getX(), player.getY(), player.getZ(), input);
                item.setNoPickUpDelay();
                level.addFreshEntity((Entity)item);
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tile;
        if (state.getBlock() != newState.getBlock() && (tile = level.getBlockEntity(pos)) instanceof EssenceVesselTileEntity) {
            EssenceVesselTileEntity vessel = (EssenceVesselTileEntity)tile;
            Containers.dropContents((Level)level, (BlockPos)pos, (NonNullList)vessel.getInventory().getStacks());
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return VESSEL_SHAPE;
    }
}

