/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.augment;

import com.blakebr0.cucumber.helper.ColorHelper;
import com.blakebr0.mysticalagriculture.api.tinkering.Augment;
import com.blakebr0.mysticalagriculture.api.tinkering.AugmentType;
import java.util.EnumSet;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.common.ItemAbilities;

public class PathingAOEAugment
extends Augment {
    private final int range;

    public PathingAOEAugment(ResourceLocation id, int tier, int range) {
        super(id, tier, EnumSet.of(AugmentType.SHOVEL), PathingAOEAugment.getColor(11177290, tier), PathingAOEAugment.getColor(8743738, tier));
        this.range = range;
    }

    @Override
    public boolean onItemUse(UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return false;
        }
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        boolean playedSound = false;
        if (PathingAOEAugment.path(context, pos)) {
            level.playSound(player, pos, SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS, 1.0f, 1.0f);
            playedSound = true;
            if (!player.isCrouching()) {
                return false;
            }
        }
        if (player.isCrouching()) {
            Iterator positions = BlockPos.betweenClosedStream((BlockPos)pos.offset(-this.range, 0, -this.range), (BlockPos)pos.offset(this.range, 0, this.range)).iterator();
            while (positions.hasNext()) {
                BlockPos aoePos = (BlockPos)positions.next();
                if (!PathingAOEAugment.path(context, aoePos) || playedSound) continue;
                level.playSound(player, pos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                playedSound = true;
            }
        }
        return true;
    }

    private static boolean path(UseOnContext context, BlockPos pos) {
        BlockState modifiedState;
        Level level = context.getLevel();
        Direction direction = context.getClickedFace();
        if (direction != Direction.DOWN && level.isEmptyBlock(pos.above()) && (modifiedState = level.getBlockState(pos).getToolModifiedState(context, ItemAbilities.SHOVEL_FLATTEN, false)) != null) {
            if (!level.isClientSide()) {
                ItemStack stack = context.getItemInHand();
                Player player = context.getPlayer();
                level.setBlock(pos, modifiedState, 11);
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)modifiedState));
                if (player != null) {
                    stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                }
            }
            return true;
        }
        return false;
    }

    private static int getColor(int color, int tier) {
        return ColorHelper.saturate((int)color, (float)Math.min((float)tier / 5.0f, 1.0f));
    }
}

