/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.augment;

import com.blakebr0.cucumber.helper.BlockHelper;
import com.blakebr0.cucumber.helper.ColorHelper;
import com.blakebr0.mysticalagriculture.api.tinkering.Augment;
import com.blakebr0.mysticalagriculture.api.tinkering.AugmentType;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class MiningAOEAugment
extends Augment {
    private final int range;

    public MiningAOEAugment(ResourceLocation id, int tier, int range) {
        super(id, tier, EnumSet.of(AugmentType.PICKAXE, AugmentType.AXE, AugmentType.SHOVEL), MiningAOEAugment.getColor(14024694, tier), MiningAOEAugment.getColor(965309, tier));
        this.range = range;
    }

    @Override
    public boolean onBlockDestroyed(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entity) {
        if (level.isClientSide()) {
            return false;
        }
        if (entity.isShiftKeyDown()) {
            return false;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            BlockHitResult trace = BlockHelper.rayTraceBlocks((Level)level, (Player)player);
            int side = trace.getDirection().ordinal();
            MiningAOEAugment.harvestAOEBlocks(stack, this.range, level, pos, side, player);
        }
        return false;
    }

    private static void harvestAOEBlocks(ItemStack stack, int radius, Level level, BlockPos pos, int side, Player player) {
        int xRange = radius;
        int yRange = radius;
        int zRange = 0;
        if (side == 0 || side == 1) {
            zRange = radius;
            yRange = 0;
        }
        if (side == 4 || side == 5) {
            xRange = 0;
            zRange = radius;
        }
        BlockState state = level.getBlockState(pos);
        float hardness = state.getDestroySpeed((BlockGetter)level, pos);
        if (radius > 0 && hardness >= 0.2f && MiningAOEAugment.canHarvestBlock(stack, state)) {
            BlockPos.betweenClosedStream((BlockPos)pos.offset(-xRange, -yRange, -zRange), (BlockPos)pos.offset(xRange, yRange, zRange)).forEach(aoePos -> {
                BlockState aoeState;
                if (aoePos != pos && MiningAOEAugment.canHarvestBlock(stack, aoeState = level.getBlockState(aoePos)) && !aoeState.hasBlockEntity() && aoeState.getDestroySpeed((BlockGetter)level, aoePos) <= hardness + 5.0f) {
                    BlockHelper.harvestAOEBlock((ItemStack)stack, (Level)level, (ServerPlayer)((ServerPlayer)player), (BlockPos)aoePos.immutable());
                }
            });
        }
    }

    private static boolean canHarvestBlock(ItemStack stack, BlockState state) {
        return stack.isCorrectToolForDrops(state) || !state.requiresCorrectToolForDrops() && stack.getDestroySpeed(state) > 1.0f;
    }

    private static int getColor(int color, int tier) {
        return ColorHelper.saturate((int)color, (float)Math.min((float)tier / 5.0f, 1.0f));
    }
}

