/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.client.particles.laserparticle;

import com.direwolf20.mininggadgets.client.particles.laserparticle.LaserParticleData;
import com.direwolf20.mininggadgets.common.items.MiningGadget;
import com.direwolf20.mininggadgets.common.items.gadget.MiningProperties;
import com.direwolf20.mininggadgets.common.tiles.RenderBlockTileEntity;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.UUID;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.BreakingItemParticle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class LaserParticle
extends BreakingItemParticle {
    public static final ParticleProvider<LaserParticleData> FACTORY = (data, world, x, y, z, xSpeed, ySpeed, zSpeed) -> new LaserParticle(world, x, y, z, xSpeed, ySpeed, zSpeed, data.size, data.depthTest, data.maxAgeMul, data.state);
    private BlockState blockState;
    private UUID playerUUID;
    private int speedModifier;
    private boolean voiding = false;
    private final double sourceX;
    private final double sourceY;
    private final double sourceZ;
    private final float originalSize;

    public LaserParticle(ClientLevel world, double d, double d1, double d2, double xSpeed, double ySpeed, double zSpeed, float size, boolean depthTest, float maxAgeMul, BlockState blockState) {
        this(world, d, d1, d2, xSpeed, ySpeed, zSpeed, size, depthTest, maxAgeMul, new ItemStack((ItemLike)blockState.getBlock()));
        this.blockState = blockState;
        if (this.blockState.getBlock() == Blocks.GRASS_BLOCK) {
            this.rCol = 1.0f;
            this.gCol = 1.0f;
            this.bCol = 1.0f;
            return;
        }
        BlockColors blockColors = Minecraft.getInstance().getBlockColors();
        int color = blockColors.getColor(this.blockState, (BlockAndTintGetter)this.level, new BlockPos((int)d, (int)d1, (int)d2), 0);
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        this.rCol = f;
        this.gCol = f1;
        this.bCol = f2;
    }

    public LaserParticle(ClientLevel world, double d, double d1, double d2, double xSpeed, double ySpeed, double zSpeed, float size, boolean depthTest, float maxAgeMul, ItemStack stack) {
        super(world, d, d1, d2, stack);
        this.xd = xSpeed;
        this.yd = ySpeed;
        this.zd = zSpeed;
        this.gravity = 0.0f;
        this.quadSize *= size;
        this.originalSize = this.quadSize;
        this.lifetime = Math.round(maxAgeMul);
        this.setSize(0.001f, 0.001f);
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        BlockEntity blockEntity = world.getBlockEntity(new BlockPos((int)Math.floor(this.x), (int)Math.floor(this.y), (int)Math.floor(this.z)));
        if (blockEntity instanceof RenderBlockTileEntity) {
            RenderBlockTileEntity te = (RenderBlockTileEntity)blockEntity;
            this.playerUUID = te.getPlayerUUID();
            this.voiding = !te.getBlockAllowed();
        }
        this.sourceX = d;
        this.sourceY = d1;
        this.sourceZ = d2;
        this.hasPhysics = false;
    }

    public void render(VertexConsumer builder, Camera activeRenderInfo, float partialTicks) {
        super.render(builder, activeRenderInfo, partialTicks);
    }

    public boolean particleToPlayer(Player player) {
        BlockEntity te;
        boolean partToPlayer = false;
        BlockPos sourcePos = new BlockPos((int)Math.floor(this.sourceX), (int)Math.floor(this.sourceY), (int)Math.floor(this.sourceZ));
        if (this.level.getBlockState(sourcePos) != this.blockState) {
            partToPlayer = true;
        }
        if ((te = this.level.getBlockEntity(sourcePos)) != null && te instanceof RenderBlockTileEntity && ((RenderBlockTileEntity)te).getTicksSinceMine() >= 5) {
            partToPlayer = false;
        }
        return partToPlayer;
    }

    public void tick() {
        double moveZ;
        double moveY;
        double moveX;
        if (this.playerUUID == null) {
            this.remove();
            return;
        }
        Player player = this.level.getPlayerByUUID(this.playerUUID);
        if (player == null) {
            this.remove();
            return;
        }
        Vec3 playerPos = player.position().add(0.0, (double)player.getEyeHeight(), 0.0);
        Vec3 blockPos = new Vec3(this.sourceX, this.sourceY, this.sourceZ);
        Vec3 look = player.getLookAngle();
        Vec3 right = new Vec3(-look.z, 0.0, look.x).normalize();
        Vec3 forward = look;
        Vec3 down = right.cross(forward);
        boolean isRightHand = player.getMainHandItem().getItem() instanceof MiningGadget;
        right = right.scale(isRightHand ? (double)0.65f : (double)-0.65f);
        forward = forward.scale((double)0.85f);
        down = down.scale(-0.35);
        Vec3 laserPos = playerPos.add(right);
        laserPos = laserPos.add(forward);
        laserPos = laserPos.add(down);
        Vec3 partPos = new Vec3(this.x, this.y, this.z);
        Vec3 targetDirection = new Vec3(laserPos.x() - this.x, laserPos.y() - this.y, laserPos.z() - this.z);
        double totalDistance = blockPos.distanceTo(laserPos);
        if (this.particleToPlayer(player)) {
            ++this.speedModifier;
            speedAdjust = 30 - this.speedModifier <= 0 ? 1 : 30 - this.speedModifier;
            double distance = laserPos.distanceTo(partPos);
            if (distance < 0.25) {
                this.remove();
            }
            if (this.age > 5) {
                float spinSpeed = Mth.lerp((float)(1.0f - (float)distance / (float)totalDistance), (float)1.1f, (float)0.05f);
                targetDirection = targetDirection.add(targetDirection.cross(look).scale((double)spinSpeed).multiply(3.0, 3.0, 3.0));
            }
            this.quadSize *= Mth.lerp((float)(1.0f - (float)distance / (float)totalDistance), (float)1.05f, (float)0.85f);
            moveX = targetDirection.x() / (double)speedAdjust;
            moveY = targetDirection.y() / (double)speedAdjust;
            moveZ = targetDirection.z() / (double)speedAdjust;
            ItemStack heldItem = MiningGadget.getGadget(player);
            if (heldItem.getItem() instanceof MiningGadget && MiningProperties.getRange(heldItem) > 1 && this.age < 5) {
                int compressionFactor = 7;
                moveX *= (1.0 - Math.abs(look.x)) * (double)compressionFactor;
                moveY *= (1.0 - Math.abs(look.y)) * (double)compressionFactor;
                moveZ *= (1.0 - Math.abs(look.z)) * (double)compressionFactor;
            }
        } else {
            this.speedModifier = 0;
            speedAdjust = 20 - this.speedModifier <= 0 ? 1 : 20 - this.speedModifier;
            double distance = blockPos.distanceTo(partPos);
            if (distance < 0.75) {
                this.remove();
            }
            moveX = (this.sourceX - this.x) / (double)speedAdjust;
            moveY = (this.sourceY - this.y) / (double)speedAdjust;
            moveZ = (this.sourceZ - this.z) / (double)speedAdjust;
        }
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.voiding && this.age > 10 && this.age <= 15) {
            float darkness;
            this.rCol = darkness = Mth.lerp((float)((float)(this.age - 10) / 5.0f), (float)1.0f, (float)0.0f);
            this.gCol = darkness;
            this.bCol = darkness;
        }
        if (this.voiding && this.age > 15 && this.age <= 25) {
            float fade = Mth.lerp((float)(((float)this.age - 15.0f) / 10.0f), (float)1.0f, (float)0.0f);
            this.quadSize = this.originalSize * fade;
        }
        this.move(moveX, moveY, moveZ);
    }
}

