/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.api.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkManagerImpl;
import dev.ftb.mods.ftbchunks.net.ServerConfigResponsePacket;
import dev.ftb.mods.ftbchunks.util.DimensionFilter;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.snbt.config.ConfigUtil;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import java.nio.file.Path;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public record ServerConfigRequestPacket(SNBTCompoundTag config) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerConfigRequestPacket> TYPE = new CustomPacketPayload.Type(FTBChunksAPI.rl("server_config_request_packet"));
    public static final StreamCodec<FriendlyByteBuf, ServerConfigRequestPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)SNBTCompoundTag.STREAM_CODEC, ServerConfigRequestPacket::config, ServerConfigRequestPacket::new);

    public CustomPacketPayload.Type<ServerConfigRequestPacket> type() {
        return TYPE;
    }

    public static void handle(ServerConfigRequestPacket message, NetworkManager.PacketContext context) {
        ServerPlayer sp;
        Player player = context.getPlayer();
        if (player instanceof ServerPlayer && (sp = (ServerPlayer)player).hasPermissions(2)) {
            context.queue(() -> {
                MinecraftServer server = sp.getServer();
                FTBChunks.LOGGER.info("FTB Chunks server config updated from client by player {}", (Object)sp.getName().getString());
                FTBChunksWorldConfig.CONFIG.read(message.config);
                DimensionFilter.clearMatcherCaches();
                Path file = server.getWorldPath(ConfigUtil.SERVER_CONFIG_DIR).resolve(FTBChunksWorldConfig.CONFIG.key + ".snbt");
                FTBChunksWorldConfig.CONFIG.save(file);
                for (ServerPlayer player : server.getPlayerList().getPlayers()) {
                    if (sp.getUUID().equals(player.getUUID())) continue;
                    NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ServerConfigResponsePacket(message.config));
                }
                FTBTeamsAPI.api().getManager().getTeams().forEach(team -> ClaimedChunkManagerImpl.getInstance().getOrCreateData((Team)team).updateLimits());
            });
        }
    }
}

