/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.minimap.components;

import dev.ftb.mods.ftbchunks.api.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.api.client.minimap.MinimapContext;
import dev.ftb.mods.ftbchunks.api.client.minimap.MinimapInfoComponent;
import dev.ftb.mods.ftbchunks.client.ClientTaskQueue;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftbchunks.client.map.ChunkUpdateTask;
import dev.ftb.mods.ftbchunks.client.map.MapManager;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftblibrary.util.StringUtils;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class DebugComponent
implements MinimapInfoComponent {
    public static final ResourceLocation ID = FTBChunksAPI.rl("debug");

    @Override
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void render(MinimapContext context, GuiGraphics graphics, Font font) {
        ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
        long memory = MapManager.getInstance().map(MapManager::estimateMemoryUsage).orElse(0L);
        components.add(Component.literal((String)("TQ: " + ClientTaskQueue.queueSize())).withStyle(ChatFormatting.GRAY));
        components.add(Component.literal((String)("Rgn: " + String.valueOf(XZ.of((int)context.mapChunksPos().x(), (int)context.mapChunksPos().z())))).withStyle(ChatFormatting.GRAY));
        components.add(Component.literal((String)("Mem: ~" + StringUtils.formatDouble00((double)((double)memory / 1024.0 / 1024.0)) + " MB")).withStyle(ChatFormatting.GRAY));
        components.add(Component.literal((String)("Updates: " + FTBChunksClient.INSTANCE.getRenderedDebugCount())).withStyle(ChatFormatting.GRAY));
        if (ChunkUpdateTask.getDebugLastTime() > 0L) {
            components.add(Component.literal((String)String.format("Last: %,d ns", ChunkUpdateTask.getDebugLastTime())).withStyle(ChatFormatting.GRAY));
        }
        int y = 0;
        int n = this.computeLineHeight(context.minecraft(), 1);
        Objects.requireNonNull(font);
        int lineHeight = n + 9 + 1;
        for (Component component : components) {
            this.drawCenteredText(context.minecraft().font, graphics, component, y);
            y += lineHeight;
        }
    }

    @Override
    public int height(MinimapContext context) {
        return this.computeLineHeight(context.minecraft(), 5) + 1;
    }
}

