/*
 * Decompiled with CFR 0.152.
 */
package com.ofekn.crafting_on_a_stick;

import com.ofekn.crafting_on_a_stick.COASUtils;
import com.ofekn.crafting_on_a_stick.ItemOnAStick;
import com.ofekn.crafting_on_a_stick.MinecraftMenuBuilder;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.CartographyTableMenu;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.GrindstoneMenu;
import net.minecraft.world.inventory.LoomMenu;
import net.minecraft.world.inventory.SmithingMenu;
import net.minecraft.world.inventory.StonecutterMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class ModItems {
    public static final DeferredRegister.Items REGISTER = DeferredRegister.createItems((String)"crafting_on_a_stick");
    public static final DeferredItem<ItemOnAStick> CRAFTING_TABLE = ModItems.createItem(Blocks.CRAFTING_TABLE, "crafting", (a, b, c) -> new CraftingMenu(a, b, c){

        public boolean stillValid(Player player) {
            return ModItems.doPlayerHave(player, CRAFTING_TABLE);
        }
    });
    public static final DeferredItem<ItemOnAStick> LOOM = ModItems.createItem(Blocks.LOOM, "loom", (a, b, c) -> new LoomMenu(a, b, c){

        public boolean stillValid(Player player) {
            return ModItems.doPlayerHave(player, LOOM);
        }
    });
    public static final DeferredItem<ItemOnAStick> GRINDSTONE = ModItems.createItem(Blocks.GRINDSTONE, "grindstone_title", (a, b, c) -> new GrindstoneMenu(a, b, c){

        public boolean stillValid(Player player) {
            return ModItems.doPlayerHave(player, GRINDSTONE);
        }
    });
    public static final DeferredItem<ItemOnAStick> CARTOGRAPHY_TABLE = ModItems.createItem(Blocks.CARTOGRAPHY_TABLE, "cartography_table", (a, b, c) -> new CartographyTableMenu(a, b, c){

        public boolean stillValid(Player player) {
            return ModItems.doPlayerHave(player, CARTOGRAPHY_TABLE);
        }
    });
    public static final DeferredItem<ItemOnAStick> STONECUTTER = ModItems.createItem(Blocks.STONECUTTER, "stonecutter", (a, b, c) -> new StonecutterMenu(a, b, c){

        public boolean stillValid(Player player) {
            return ModItems.doPlayerHave(player, STONECUTTER);
        }
    });
    public static final DeferredItem<ItemOnAStick> SMITHING_TABLE = ModItems.createItem(Blocks.SMITHING_TABLE, "upgrade", (a, b, c) -> new SmithingMenu(a, b, c){

        public boolean stillValid(Player player) {
            return ModItems.doPlayerHave(player, SMITHING_TABLE);
        }
    });
    public static final DeferredItem<ItemOnAStick> ANVIL = ModItems.createAnvil(Blocks.ANVIL);
    public static final DeferredItem<ItemOnAStick> CHIPPED_ANVIL = ModItems.createAnvil(Blocks.CHIPPED_ANVIL);
    public static final DeferredItem<ItemOnAStick> DAMAGED_ANVIL = ModItems.createAnvil(Blocks.DAMAGED_ANVIL);

    private ModItems() {
    }

    private static boolean doPlayerHave(Player player, DeferredItem<ItemOnAStick> itemReg) {
        Item item = (Item)itemReg.get();
        IItemHandlerModifiable inventory = COASUtils.getFullInventory(player);
        int size = inventory.getSlots();
        for (int i = 0; i < size; ++i) {
            ItemStack invStack = inventory.getStackInSlot(i);
            if (invStack.isEmpty() || invStack.getItem() != item) continue;
            return true;
        }
        return false;
    }

    private static DeferredItem<ItemOnAStick> createItem(Block block, String containerName, MinecraftMenuBuilder builder) {
        ResourceKey blockKey = (ResourceKey)BuiltInRegistries.BLOCK.getResourceKey((Object)block).orElseThrow();
        String path = blockKey.location().getPath();
        return REGISTER.register(path, () -> new ItemOnAStick(path, containerName, builder));
    }

    private static DeferredItem<ItemOnAStick> createAnvil(Block block) {
        return ModItems.createItem(block, "repair", (a, b, c) -> new AnvilMenu(a, b, c){

            public boolean stillValid(Player player) {
                return ModItems.doPlayerHave(player, DAMAGED_ANVIL) || ModItems.doPlayerHave(player, CHIPPED_ANVIL) || ModItems.doPlayerHave(player, ANVIL);
            }

            protected void onTake(Player p_150474_, ItemStack p_150475_) {
                if (!p_150474_.getAbilities().instabuild) {
                    p_150474_.giveExperienceLevels(-this.getCost());
                }
                float breakChance = CommonHooks.onAnvilRepair((Player)p_150474_, (ItemStack)p_150475_, (ItemStack)this.inputSlots.getItem(0), (ItemStack)this.inputSlots.getItem(1));
                this.inputSlots.setItem(0, ItemStack.EMPTY);
                if (this.repairItemCountCost > 0) {
                    ItemStack itemstack = this.inputSlots.getItem(1);
                    if (!itemstack.isEmpty() && itemstack.getCount() > this.repairItemCountCost) {
                        itemstack.shrink(this.repairItemCountCost);
                        this.inputSlots.setItem(1, itemstack);
                    } else {
                        this.inputSlots.setItem(1, ItemStack.EMPTY);
                    }
                } else {
                    this.inputSlots.setItem(1, ItemStack.EMPTY);
                }
                this.setMaximumCost(0L);
                this.access.execute((p_150479_, p_150480_) -> p_150479_.levelEvent(ModItems.damageAnvil(p_150474_, breakChance) ? 1029 : 1030, p_150480_, 0));
            }
        });
    }

    private static boolean damageAnvil(Player player, float breakChance) {
        if (player.getAbilities().instabuild || player.getRandom().nextFloat() >= breakChance) {
            return false;
        }
        ItemStack candidate = ModItems.damageAnvilItemStack(player.getItemInHand(InteractionHand.MAIN_HAND));
        if (candidate != null) {
            player.setItemInHand(InteractionHand.MAIN_HAND, candidate);
            return candidate.isEmpty();
        }
        candidate = ModItems.damageAnvilItemStack(player.getItemInHand(InteractionHand.OFF_HAND));
        if (candidate != null) {
            player.setItemInHand(InteractionHand.OFF_HAND, candidate);
            return candidate.isEmpty();
        }
        IItemHandlerModifiable inventory = COASUtils.getFullInventory(player);
        int invSize = inventory.getSlots();
        for (int i = 0; i < invSize; ++i) {
            candidate = ModItems.damageAnvilItemStack(inventory.getStackInSlot(i));
            if (candidate == null) continue;
            inventory.setStackInSlot(i, candidate);
            return candidate.isEmpty();
        }
        return false;
    }

    @Nullable
    private static ItemStack damageAnvilItemStack(ItemStack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        Item item = stack.getItem();
        if (item == ANVIL.get()) {
            return new ItemStack((ItemLike)CHIPPED_ANVIL.get());
        }
        if (item == CHIPPED_ANVIL.get()) {
            return new ItemStack((ItemLike)DAMAGED_ANVIL.get());
        }
        if (item == DAMAGED_ANVIL.get()) {
            return ItemStack.EMPTY;
        }
        return null;
    }
}

