/*
 * Decompiled with CFR 0.152.
 */
package mrbysco.constructionstick.containers.handlers;

import mrbysco.constructionstick.api.IContainerHandler;
import mrbysco.constructionstick.basics.StickUtil;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;

public class HandlerShulkerbox
implements IContainerHandler {
    private final int SLOTS = 27;

    @Override
    public boolean matches(Player player, ItemStack itemStack, ItemStack inventoryStack) {
        return inventoryStack != null && inventoryStack.getCount() == 1 && Block.byItem((Item)inventoryStack.getItem()) instanceof ShulkerBoxBlock;
    }

    @Override
    public int countItems(Player player, ItemStack itemStack, ItemStack inventoryStack) {
        int count = 0;
        for (ItemStack stack : this.getItemList(inventoryStack)) {
            if (!StickUtil.stackEquals(stack, itemStack)) continue;
            count += stack.getCount();
        }
        return count;
    }

    @Override
    public int useItems(Player player, ItemStack itemStack, ItemStack inventoryStack, int count) {
        NonNullList<ItemStack> itemList = this.getItemList(inventoryStack);
        boolean changed = false;
        for (ItemStack stack : itemList) {
            if (!StickUtil.stackEquals(stack, itemStack)) continue;
            int toTake = Math.min(count, stack.getCount());
            stack.shrink(toTake);
            changed = true;
            if ((count -= toTake) != 0) continue;
            break;
        }
        if (changed) {
            this.setItemList(inventoryStack, itemList);
            player.getInventory().setChanged();
        }
        return count;
    }

    private NonNullList<ItemStack> getItemList(ItemStack itemStack) {
        NonNullList itemStacks = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
        ItemContainerContents contents = (ItemContainerContents)itemStack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY);
        itemStacks.addAll(contents.stream().toList());
        return itemStacks;
    }

    private void setItemList(ItemStack itemStack, NonNullList<ItemStack> itemStacks) {
        itemStack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(itemStacks));
    }
}

