/*
 * Decompiled with CFR 0.152.
 */
package mrbysco.constructionstick.basics.option;

import mrbysco.constructionstick.basics.option.IOption;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;

public class OptionBoolean
implements IOption<Boolean> {
    private final ItemStack stack;
    private final DataComponentType<Boolean> componentType;
    private final String key;
    private final boolean enabled;
    private boolean value;

    public OptionBoolean(ItemStack stack, DataComponentType<Boolean> componentType, String key, boolean dval, boolean enabled) {
        this.stack = stack;
        this.componentType = componentType;
        this.key = key;
        this.enabled = enabled;
        this.value = (Boolean)stack.getOrDefault(componentType, (Object)dval);
    }

    public OptionBoolean(ItemStack stack, DataComponentType<Boolean> componentType, String key, boolean dval) {
        this(stack, componentType, key, dval, true);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public DataComponentType<Boolean> getComponentType() {
        return this.componentType;
    }

    @Override
    public String getValueString() {
        return this.value ? "yes" : "no";
    }

    @Override
    public void setValueString(String val) {
        this.set(val.equals("yes"));
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void set(Boolean val) {
        if (!this.enabled) {
            return;
        }
        this.value = val;
        this.stack.set(this.componentType, (Object)val);
    }

    @Override
    public Boolean get() {
        return this.value;
    }

    @Override
    public Boolean next(boolean dir) {
        this.set(!this.value);
        return this.value;
    }
}

