/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.hurts.sskirillss.relics.api.events.common.TooltipDisplayEvent;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.utils.RenderUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.joml.Vector2ic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={GuiGraphics.class})
public class GuiGraphicsMixin {
    @Inject(method={"renderTooltipInternal"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;popPose()V", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILSOFT)
    public void onTooltipRender(Font font, List<ClientTooltipComponent> tooltip, int x, int y, ClientTooltipPositioner positioner, CallbackInfo info, RenderTooltipEvent.Pre event, int width, int height, int postWidth, int postHeight, Vector2ic postPos) {
        if (!tooltip.isEmpty()) {
            NeoForge.EVENT_BUS.post((Event)new TooltipDisplayEvent(event.getItemStack(), (GuiGraphics)this, postWidth, postHeight, postPos.x(), postPos.y()));
        }
    }

    @Inject(method={"renderItem(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;IIII)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;scale(FFF)V", shift=At.Shift.AFTER)})
    public void renderItem(LivingEntity entity, Level level, ItemStack stack, int x, int y, int seed, int guiOffset, CallbackInfo ci) {
        IRelicItem relic;
        Item item;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || !((item = stack.getItem()) instanceof IRelicItem) || !(relic = (IRelicItem)item).isRelicFlawless(stack)) {
            return;
        }
        BeamsData data = relic.getStyleData().getBeams().apply((Player)player, stack);
        GuiGraphics guiGraphics = (GuiGraphics)this;
        PoseStack poseStack = guiGraphics.pose();
        float partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
        int beams = 8;
        float time = (float)player.tickCount + partialTicks;
        for (int i = 0; i < beams; ++i) {
            float angle = (float)((double)((float)i * 2.0f) * Math.PI / (double)beams);
            poseStack.pushPose();
            poseStack.mulPose(Axis.ZP.rotation(angle));
            poseStack.mulPose(Axis.ZP.rotation(time * 0.025f));
            double length = (double)0.85f + (i % 2 == 0 ? Math.sin(time * 0.25f) : Math.cos(time * 0.25f)) * (double)0.1f;
            RenderUtils.renderFlatBeam(guiGraphics, partialTicks, (float)length, 0.45f, data.getStartColor(), data.getEndColor());
            poseStack.popPose();
        }
    }
}

