/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.entities;

import it.hurts.sskirillss.relics.entities.BlockSimulationEntity;
import it.hurts.sskirillss.relics.init.EntityRegistry;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ShockwaveEntity
extends ThrowableProjectile {
    private int radius;
    private float damage;
    private int step;
    private List<BlockPos> poses = new ArrayList<BlockPos>();

    public ShockwaveEntity(EntityType<? extends ThrowableProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public ShockwaveEntity(Level level, int radius, float damage) {
        super((EntityType)EntityRegistry.SHOCKWAVE.get(), level);
        this.radius = radius;
        this.damage = damage;
    }

    public void tick() {
        super.tick();
        BlockPos center = this.blockPosition();
        Level level = this.level();
        if (this.poses.isEmpty()) {
            for (int i = -this.radius; i <= this.radius; ++i) {
                float r1 = Mth.sqrt((float)(this.radius * this.radius - i * i));
                int j = -((int)r1);
                while ((float)j <= r1) {
                    this.poses.add(center.offset(i, 0, j));
                    ++j;
                }
            }
        }
        if (!this.poses.isEmpty()) {
            Entity owner = this.getOwner();
            Vec3 centerVec = new Vec3((double)center.getX(), (double)center.getY(), (double)center.getZ());
            List<BlockPos> closest = this.poses.stream().filter(p -> new Vec3((double)p.getX(), (double)p.getY(), (double)p.getZ()).distanceTo(centerVec) <= (double)this.step).toList();
            this.poses.removeAll(closest);
            for (BlockPos p2 : closest) {
                BlockState state;
                if (!level.isClientSide()) {
                    float damage = (float)this.radius * this.damage / (float)this.step;
                    if (Float.isNaN(damage)) {
                        damage = 1.0f;
                    }
                    for (LivingEntity entity : level.getEntitiesOfClass(LivingEntity.class, new AABB(Vec3.atCenterOf((Vec3i)p2), Vec3.atCenterOf((Vec3i)p2.above(3))).inflate(0.5))) {
                        if (owner != null && entity.getStringUUID().equals(owner.getStringUUID())) continue;
                        Entity entity2 = this.getOwner();
                        if (entity2 instanceof Player) {
                            Player player = (Player)entity2;
                            EntityUtils.hurt(entity, this.level().damageSources().playerAttack(player), damage);
                        } else {
                            entity.hurt(this.level().damageSources().magic(), damage);
                        }
                        entity.setDeltaMovement(entity.position().add(0.0, 1.0, 0.0).subtract(centerVec).normalize().multiply(2.0, 1.0, 2.0));
                    }
                }
                if (!(state = level.getBlockState(p2)).blocksMotion() || level.getBlockState(p2.above()).blocksMotion()) continue;
                BlockSimulationEntity entity = new BlockSimulationEntity(level, state);
                entity.setPos((float)p2.getX() + 0.5f, (float)p2.getY() + 0.5f, (float)p2.getZ() + 0.5f);
                entity.setDeltaMovement(0.0, (float)this.step * 0.02f, 0.0);
                level.addFreshEntity((Entity)entity);
            }
            ++this.step;
            if (this.poses.isEmpty() || this.step >= this.poses.size()) {
                this.remove(Entity.RemovalReason.KILLED);
            }
        } else {
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.radius = compound.getInt("Radius");
        this.damage = compound.getFloat("Damage");
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("Radius", this.radius);
        compound.putFloat("Damage", this.damage);
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public float getDamage() {
        return this.damage;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int step) {
        this.step = step;
    }

    public List<BlockPos> getPoses() {
        return this.poses;
    }

    public void setPoses(List<BlockPos> poses) {
        this.poses = poses;
    }
}

