/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.entities;

import it.hurts.sskirillss.relics.init.EffectRegistry;
import it.hurts.sskirillss.relics.init.EntityRegistry;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.PacketPlayerMotion;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DissectionEntity
extends Entity {
    private static final EntityDataAccessor<Integer> LIFE_TIME = SynchedEntityData.defineId(DissectionEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private boolean isMaster = false;
    private int maxLifeTime;
    public List<UUID> entities = new ArrayList<UUID>();
    public List<UUID> blacklist = new ArrayList<UUID>();
    public boolean locked = true;
    public UUID pair;

    public int getLifeTime() {
        return (Integer)this.getEntityData().get(LIFE_TIME);
    }

    public void setLifeTime(int amount) {
        this.getEntityData().set(LIFE_TIME, (Object)amount);
    }

    public DissectionEntity(EntityType<?> pEntityType, Level level) {
        super(pEntityType, level);
        this.noPhysics = true;
    }

    public DissectionEntity(Level level) {
        super((EntityType)EntityRegistry.DISSECTION.get(), level);
        this.noPhysics = true;
    }

    @Nullable
    public DissectionEntity getPair() {
        DissectionEntity dissection;
        if (this.pair == null || this.level().isClientSide()) {
            return null;
        }
        Entity entity = ((ServerLevel)this.level()).getEntity(this.pair);
        return entity instanceof DissectionEntity ? (dissection = (DissectionEntity)entity) : null;
    }

    public void setPair(Entity entity) {
        if (!(entity instanceof DissectionEntity)) {
            return;
        }
        this.pair = entity.getUUID();
    }

    public void tick() {
        super.tick();
        RandomSource random = this.level().getRandom();
        this.clearFire();
        if (this.tickCount > 5) {
            for (int i = 0; i < 5; ++i) {
                float step = Math.max(Math.min(this.getLifeTime() > 20 ? (float)(this.tickCount - 5) * 0.075f : (float)this.getLifeTime() * 0.075f, 1.0f), 0.0f);
                float mul = random.nextFloat() * 0.3f;
                Vec3 pos2 = this.position().add(this.getLookAngle()).add(0.0, (double)(this.getBbHeight() / 2.0f), 0.0).add((double)(MathUtils.randomFloat(random) * step), (double)(MathUtils.randomFloat(random) * step), (double)(MathUtils.randomFloat(random) * step));
                Vec3 angle = this.getLookAngle().normalize().multiply((double)mul, (double)mul, (double)mul);
                this.level().addParticle(ParticleUtils.constructSimpleSpark(new Color(150 + random.nextInt(100), 100, 0), 0.2f + random.nextFloat() * 0.1f, 10 + random.nextInt(20), 0.9f), pos2.x(), pos2.y(), pos2.z(), angle.x(), angle.y(), angle.z());
            }
        }
        if (this.level().isClientSide()) {
            return;
        }
        this.locked = false;
        ServerLevel serverLevel = (ServerLevel)this.level();
        DissectionEntity pair = this.getPair();
        if (pair == null) {
            if (!this.isMaster() || this.getMaxLifeTime() == 0 || this.getLifeTime() != this.getMaxLifeTime()) {
                this.discard();
            }
            return;
        }
        if (this.isMaster()) {
            int time = this.getLifeTime();
            if (time > 0) {
                this.setLifeTime(--time);
                pair.setLifeTime(time);
            } else {
                this.discard();
            }
        }
        this.lookAt(EntityAnchorArgument.Anchor.FEET, pair.position());
        Vec3 currentVec = this.position().add(this.getLookAngle()).add(0.0, 1.25, 0.0);
        Vec3 nextVec = pair.position().add(pair.getLookAngle()).add(0.0, 1.25, 0.0);
        int distance = (int)Math.round(currentVec.distanceTo(nextVec));
        Vec3 finalVec = currentVec.add(nextVec.subtract(currentVec).normalize().multiply((double)distance, (double)distance, (double)distance));
        distance = (int)Math.round(currentVec.distanceTo(finalVec));
        for (int j = 0; j < distance; ++j) {
            float x = (float)((finalVec.x - currentVec.x) * (double)j / (double)distance + currentVec.x);
            float y = (float)((finalVec.y - currentVec.y) * (double)j / (double)distance + currentVec.y);
            float z = (float)((finalVec.z - currentVec.z) * (double)j / (double)distance + currentVec.z);
            BlockPos.betweenClosedStream((AABB)new AABB(new BlockPos((int)x, (int)y, (int)z))).forEach(pos -> {
                if (serverLevel.getBlockState(pos).blocksMotion()) {
                    this.locked = true;
                    serverLevel.sendParticles(ParticleUtils.constructSimpleSpark(new Color(255, random.nextInt(50), 0), 0.1f, 10, 0.9f), (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), 1, (double)0.3f, (double)0.3f, (double)0.3f, (double)0.025f);
                }
            });
        }
        if (this.locked) {
            this.entities.clear();
            return;
        }
        ArrayList<UUID> toRemoveFromEntities = new ArrayList<UUID>();
        for (UUID uuid : this.entities) {
            Entity target = serverLevel.getEntity(uuid);
            if (!(target instanceof LivingEntity)) {
                toRemoveFromEntities.add(uuid);
                continue;
            }
            if (this.blacklist.contains(uuid)) continue;
            if (target.position().distanceTo(this.position()) > this.position().distanceTo(pair.position())) {
                toRemoveFromEntities.add(uuid);
                continue;
            }
            if (!serverLevel.getEntitiesOfClass(LivingEntity.class, this.getBoundingBox()).contains(target)) {
                double mul = this.position().distanceTo(pair.position()) * (double)0.05f;
                Vec3 motion = this.position().add(0.0, (double)(this.getBbHeight() / 2.0f), 0.0).subtract(target.position()).normalize().multiply(mul, mul, mul);
                if (target instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)target;
                    NetworkHandler.sendToClient(new PacketPlayerMotion(motion.x(), motion.y(), motion.z()), player);
                } else {
                    target.setDeltaMovement(motion);
                }
                target.fallDistance = 0.0f;
                ((LivingEntity)target).addEffect(new MobEffectInstance(EffectRegistry.VANISHING, 5, 0, false, false));
                serverLevel.sendParticles(ParticleUtils.constructSimpleSpark(new Color(150 + random.nextInt(100), 100, 0), 0.2f, 20, 0.9f), target.getX(), target.getY() + 1.25, target.getZ(), Math.round(target.getBbHeight() * 3.0f), (double)0.1f, (double)0.1f, (double)0.1f, (double)0.05f);
                continue;
            }
            this.blacklist.add(target.getUUID());
            toRemoveFromEntities.add(target.getUUID());
        }
        if (!toRemoveFromEntities.isEmpty()) {
            this.entities.removeAll(toRemoveFromEntities);
        }
        ArrayList<UUID> toRemoveFromBlacklist = new ArrayList<UUID>();
        for (UUID uuid : this.blacklist) {
            if (serverLevel.getEntitiesOfClass(LivingEntity.class, this.getBoundingBox()).stream().map(Entity::getUUID).toList().contains(uuid)) continue;
            toRemoveFromBlacklist.add(uuid);
        }
        if (!toRemoveFromBlacklist.isEmpty()) {
            this.blacklist.removeAll(toRemoveFromBlacklist);
        }
        for (LivingEntity target : serverLevel.getEntitiesOfClass(LivingEntity.class, this.getBoundingBox())) {
            UUID uuid = target.getUUID();
            if (this.blacklist.contains(uuid) || this.getPair().entities.contains(uuid)) continue;
            this.getPair().entities.add(uuid);
        }
    }

    public void onRemovedFromLevel() {
        super.onRemovedFromLevel();
        if (this.isMaster()) {
            return;
        }
        DissectionEntity pair = this.getPair();
        if (pair == null) {
            return;
        }
        pair.setLifeTime(Math.min(pair.getLifeTime(), 20));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(LIFE_TIME, (Object)100);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setMaxLifeTime(compound.getInt("maxLifeTime"));
        this.setMaster(compound.getBoolean("isMaster"));
        this.setLifeTime(compound.getInt("lifeTime"));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("maxLifeTime", this.getMaxLifeTime());
        compound.putBoolean("isMaster", this.isMaster());
        compound.putInt("lifeTime", this.getLifeTime());
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public boolean isMaster() {
        return this.isMaster;
    }

    public void setMaster(boolean isMaster) {
        this.isMaster = isMaster;
    }

    public int getMaxLifeTime() {
        return this.maxLifeTime;
    }

    public void setMaxLifeTime(int maxLifeTime) {
        this.maxLifeTime = maxLifeTime;
    }
}

