/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.research.widgets;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.base.ITickingWidget;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.base.AbstractDescriptionWidget;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionTextures;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.client.screen.description.relic.particles.ExperienceParticleData;
import it.hurts.sskirillss.relics.client.screen.description.research.AbilityResearchScreen;
import it.hurts.sskirillss.relics.client.screen.utils.ParticleStorage;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.research.PacketResearchHint;
import it.hurts.sskirillss.relics.utils.data.AnimationData;
import it.hurts.sskirillss.relics.utils.data.GUIRenderer;
import it.hurts.sskirillss.relics.utils.data.SpriteAnchor;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;

public class HintWidget
extends AbstractDescriptionWidget
implements IHoverableWidget,
ITickingWidget {
    private final AbilityResearchScreen screen;

    public HintWidget(int x, int y, AbilityResearchScreen screen) {
        super(x, y, 87, 22);
        this.screen = screen;
    }

    @Override
    public void onPress() {
        IRelicItem relic;
        Item item = this.screen.stack.getItem();
        if (!(item instanceof IRelicItem) || (relic = (IRelicItem)item).isAbilityResearched(this.screen.stack, this.screen.ability)) {
            return;
        }
        int links = relic.getResearchData(this.screen.ability).getLinks().size();
        int level = this.minecraft.player.experienceLevel;
        int requiredLevel = relic.getResearchHintCost(this.screen.ability) * (Screen.hasShiftDown() ? links + 1 : 1);
        if (level >= requiredLevel) {
            NetworkHandler.sendToServer(new PacketResearchHint(this.screen.container, this.screen.slot, this.screen.ability, Screen.hasShiftDown() ? links : 1));
        }
    }

    public void renderWidget(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        Item item;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || !((item = this.screen.stack.getItem()) instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        GUIRenderer.begin(DescriptionTextures.HINT_BACKGROUND, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX(), this.getY() - 10).end();
        if (relic.isAbilityResearched(this.screen.stack, this.screen.ability)) {
            GUIRenderer.begin(DescriptionTextures.BULB_BROKEN, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX() + 34, this.getY() - 3).end();
        } else if (this.isHovered()) {
            float color = (float)((double)1.025f + Math.sin((float)player.tickCount + pPartialTick) * (double)0.05f);
            if (Screen.hasShiftDown()) {
                GUIRenderer.begin(DescriptionTextures.BULB_BURNING, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX() + 34, this.getY() - 17).patternSize(16, 34).color(color, color, color, 1.0f).animation(AnimationData.builder().frame(0, 2).frame(1, 2).frame(2, 2).frame(3, 2).frame(4, 2).frame(5, 2).frame(6, 2).frame(7, 2)).end();
            } else {
                GUIRenderer.begin(DescriptionTextures.BULB_GLOWING, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX() + 34, this.getY() - 3).color(color, color, color, 1.0f).end();
            }
        } else {
            GUIRenderer.begin(DescriptionTextures.BULB, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX() + 34, this.getY() - 3).end();
        }
        if (this.isHovered()) {
            GUIRenderer.begin(DescriptionTextures.HINT_OUTLINE, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX() - 1, this.getY() - 6).end();
        }
        poseStack.popPose();
    }

    @Override
    public void onTick() {
        IRelicItem relic;
        Item item;
        if (!this.isHovered() || !((item = this.screen.stack.getItem()) instanceof IRelicItem) || (relic = (IRelicItem)item).isAbilityResearched(this.screen.stack, this.screen.ability)) {
            return;
        }
        RandomSource random = this.minecraft.player.getRandom();
        if (this.minecraft.player.tickCount % 5 == 0) {
            ParticleStorage.addParticle(this.screen, new ExperienceParticleData(new Color(255, 200 + random.nextInt(50), random.nextInt(50)), this.getX() + 34 + random.nextInt(16), this.getY() - 6 + random.nextInt(16), 1.0f + random.nextFloat() * 0.25f, 50 + random.nextInt(50)));
        }
    }

    @Override
    public void onHovered(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Item item = this.screen.stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        PoseStack poseStack = guiGraphics.pose();
        ArrayList tooltip = Lists.newArrayList();
        int maxWidth = 150;
        int renderWidth = 0;
        int requiredLevel = relic.getResearchHintCost(this.screen.ability) * (Screen.hasShiftDown() ? relic.getResearchData(this.screen.ability).getLinks().size() : 1);
        int level = this.minecraft.player.experienceLevel;
        MutableComponent negativeStatus = Component.translatable((String)"tooltip.relics.relic.status.negative");
        MutableComponent positiveStatus = Component.translatable((String)"tooltip.relics.relic.status.positive");
        ArrayList entries = Lists.newArrayList((Object[])new MutableComponent[]{Component.translatable((String)"tooltip.relics.researching.research.hint.description").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.UNDERLINE), Component.literal((String)" ")});
        if (relic.isAbilityResearched(this.screen.stack, this.screen.ability)) {
            entries.add(Component.translatable((String)"tooltip.relics.researching.research.hint.locked"));
        } else {
            entries.add(Component.translatable((String)"tooltip.relics.relic.reset.cost", (Object[])new Object[]{requiredLevel, requiredLevel > level ? negativeStatus : positiveStatus}));
            entries.add(Component.literal((String)" "));
            entries.add(Component.literal((String)"\u25b6 ").append((Component)Component.translatable((String)"tooltip.relics.researching.research.hint.quick")));
        }
        for (MutableComponent entry : entries) {
            int entryWidth = this.minecraft.font.width((FormattedText)entry) / 2;
            if (entryWidth > renderWidth) {
                renderWidth = Math.min(entryWidth + 2, maxWidth);
            }
            tooltip.addAll(this.minecraft.font.split((FormattedText)entry, maxWidth * 2));
        }
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 100.0f);
        DescriptionUtils.drawTooltipBackground(guiGraphics, renderWidth, tooltip.size() * 5, mouseX - 9 - renderWidth / 2, mouseY);
        poseStack.scale(0.5f, 0.5f, 0.5f);
        int yOff = 0;
        for (FormattedCharSequence entry : tooltip) {
            guiGraphics.drawString(this.minecraft.font, entry, (mouseX - renderWidth / 2 + 1) * 2, (mouseY + yOff + 9) * 2, 6696723, false);
            yOff += 5;
        }
        poseStack.popPose();
    }

    @Override
    public void playDownSound(SoundManager handler) {
    }
}

