/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.general.widgets;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.base.IRelicScreenProvider;
import it.hurts.sskirillss.relics.client.screen.base.ITabbedDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.general.misc.DescriptionTab;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.base.AbstractDescriptionWidget;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionTextures;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.utils.data.GUIRenderer;
import it.hurts.sskirillss.relics.utils.data.GUIScissors;
import it.hurts.sskirillss.relics.utils.data.SpriteAnchor;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class TabWidget
extends AbstractDescriptionWidget
implements IHoverableWidget {
    private IRelicScreenProvider source;
    private IRelicScreenProvider target;
    private DescriptionTab tab;

    public TabWidget(int x, int y, IRelicScreenProvider source, DescriptionTab tab, IRelicScreenProvider target) {
        super(x, y, 17, 19);
        this.source = source;
        this.target = target;
        this.tab = tab;
    }

    @Override
    public void onPress() {
        if (this.isLocked()) {
            return;
        }
        this.minecraft.setScreen((Screen)this.target);
    }

    public void renderWidget(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        PoseStack poseStack = guiGraphics.pose();
        LocalPlayer player = this.minecraft.player;
        poseStack.pushPose();
        if (this.isLocked()) {
            GUIScissors.begin(this.getX(), this.getY(), this.width, 19);
            GUIRenderer.begin(DescriptionTextures.TAB, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX(), this.getY() + 11).end();
            GUIScissors.end();
        } else {
            GUIRenderer.begin(DescriptionTextures.TAB, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX(), this.getY()).end();
            GUIRenderer.begin(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)("textures/gui/description/general/tabs/" + this.tab.name().toLowerCase(Locale.ROOT) + ".png")), poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX() + 2, this.getY() + 5).end();
            if (this.isHovered()) {
                GUIRenderer.begin(DescriptionTextures.TAB_OUTLINE, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX() - 1, this.getY() - 1).end();
            }
        }
        poseStack.popPose();
    }

    @Override
    public boolean isLocked() {
        ITabbedDescriptionScreen screen;
        Screen screen2 = this.minecraft.screen;
        return screen2 instanceof ITabbedDescriptionScreen && (screen = (ITabbedDescriptionScreen)screen2).getTab() == this.tab;
    }

    @Override
    public void playDownSound(SoundManager handler) {
        if (!this.isLocked()) {
            super.playDownSound(handler);
        }
    }

    @Override
    public void onHovered(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        PoseStack poseStack = guiGraphics.pose();
        ArrayList tooltip = Lists.newArrayList();
        int maxWidth = 100;
        int renderWidth = 0;
        ArrayList entries = Lists.newArrayList((Object[])new MutableComponent[]{Component.translatable((String)("tooltip.relics.researching.tab." + this.tab.name().toLowerCase(Locale.ROOT))).withStyle(ChatFormatting.BOLD)});
        for (MutableComponent entry : entries) {
            int entryWidth = (this.minecraft.font.width((FormattedText)entry) + 4) / 2;
            if (entryWidth > renderWidth) {
                renderWidth = Math.min(entryWidth, maxWidth);
            }
            tooltip.addAll(this.minecraft.font.split((FormattedText)entry, maxWidth * 2));
        }
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 100.0f);
        DescriptionUtils.drawTooltipBackground(guiGraphics, renderWidth, tooltip.size() * 5, mouseX - 9 - renderWidth / 2, mouseY);
        poseStack.scale(0.5f, 0.5f, 0.5f);
        int yOff = 0;
        for (FormattedCharSequence entry : tooltip) {
            guiGraphics.drawString(this.minecraft.font, entry, (mouseX - renderWidth / 2 + 1) * 2, (mouseY + yOff + 9) * 2, 6696723, false);
            yOff += 5;
        }
        poseStack.popPose();
    }

    public IRelicScreenProvider getSource() {
        return this.source;
    }

    public IRelicScreenProvider getTarget() {
        return this.target;
    }

    public DescriptionTab getTab() {
        return this.tab;
    }
}

