/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.shrink.items;

import dev.architectury.registry.menu.MenuRegistry;
import java.util.List;
import net.creeperhost.polylib.inventory.power.IPolyEnergyStorage;
import net.creeperhost.polylib.inventory.power.PolyEnergyItem;
import net.creeperhost.polylib.inventory.power.PolyItemEnergyStorage;
import net.gigabit101.shrink.Shrink;
import net.gigabit101.shrink.ShrinkingDeviceContainer;
import net.gigabit101.shrink.api.ShrinkAPI;
import net.gigabit101.shrink.init.ShrinkComponentTypes;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemShrinkDevice
extends Item
implements MenuProvider,
PolyEnergyItem {
    public static final ResourceLocation SHRINKING_DEVICE_ID = ResourceLocation.fromNamespaceAndPath((String)"shrink", (String)"e4388c41-4cf8-4631-98b4-b26eeaedcbdc");

    public ItemShrinkDevice(Item.Properties properties) {
        super(properties);
    }

    public void writeScale(ItemStack stack, double scale) {
        stack.set((DataComponentType)ShrinkComponentTypes.SHRINKING_DEVICE.get(), (Object)scale);
    }

    public double getScale(ItemStack stack) {
        if (!stack.has((DataComponentType)ShrinkComponentTypes.SHRINKING_DEVICE.get())) {
            this.writeScale(stack, 0.0);
        }
        return (Double)stack.get((DataComponentType)ShrinkComponentTypes.SHRINKING_DEVICE.get());
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        if (player.getAttributes() != null && player.getAttribute(Attributes.SCALE) != null) {
            if (!level.isClientSide()) {
                ItemStack stack = player.getItemInHand(interactionHand);
                if (player.isShiftKeyDown()) {
                    if (!this.hasPower(player, stack)) {
                        player.displayClientMessage((Component)Component.translatable((String)"shrink.message.power"), false);
                        return InteractionResultHolder.fail((Object)stack);
                    }
                    if (!ShrinkAPI.isEntityShrunk((LivingEntity)player)) {
                        player.getAttribute(Attributes.SCALE).addPermanentModifier(ItemShrinkDevice.createModifier(this.getScale(stack)));
                        this.usePower(player, stack);
                        return InteractionResultHolder.success((Object)stack);
                    }
                    player.getAttribute(Attributes.SCALE).removeModifier(SHRINKING_DEVICE_ID);
                    this.usePower(player, stack);
                    return InteractionResultHolder.success((Object)stack);
                }
                if (!ShrinkAPI.isEntityShrunk((LivingEntity)player)) {
                    MenuRegistry.openExtendedMenu((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, friendlyByteBuf -> friendlyByteBuf.writeDouble(0.0));
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"shrink.message.already_shrunk"), false);
                }
                return InteractionResultHolder.success((Object)stack);
            }
        } else {
            player.displayClientMessage((Component)Component.translatable((String)"shrink.message.missing"), false);
        }
        return super.use(level, player, interactionHand);
    }

    @NotNull
    public InteractionResult interactLivingEntity(ItemStack itemStack, Player player, LivingEntity livingEntity, InteractionHand interactionHand) {
        if (!livingEntity.level().isClientSide() && livingEntity != null && ShrinkAPI.canEntityShrink(livingEntity) && this.hasPower(player, itemStack)) {
            if (!ShrinkAPI.isEntityShrunk(livingEntity)) {
                livingEntity.getAttribute(Attributes.SCALE).addPermanentModifier(ItemShrinkDevice.createModifier(this.getScale(itemStack)));
                this.usePower(player, itemStack);
                return InteractionResult.SUCCESS;
            }
            livingEntity.getAttribute(Attributes.SCALE).removeModifier(SHRINKING_DEVICE_ID);
            this.usePower(player, itemStack);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public boolean hasPower(Player player, ItemStack stack) {
        if (player.isCreative()) {
            return true;
        }
        return this.getEnergyStorage(stack).getEnergyStored() >= (long)Shrink.shrinkConfig.shrinkingDeviceCost;
    }

    public void usePower(Player player, ItemStack stack) {
        if (!player.isCreative()) {
            this.getEnergyStorage(stack).extractEnergy((long)Shrink.shrinkConfig.shrinkingDeviceCost, false);
        }
    }

    public static AttributeModifier createModifier(double value) {
        return new AttributeModifier(SHRINKING_DEVICE_ID, value, AttributeModifier.Operation.ADD_VALUE);
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"item.shrink.shrinking_device");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new ShrinkingDeviceContainer(id, inventory, null);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, tooltipContext, list, tooltipFlag);
        list.add((Component)Component.literal((String)(this.getEnergyStorage(stack).getEnergyStored() + " / " + this.getEnergyStorage(stack).getMaxEnergyStored() + " RF")));
    }

    public boolean isBarVisible(@NotNull ItemStack itemStack) {
        return this.getEnergyStorage(itemStack).getEnergyStored() < this.getEnergyStorage(itemStack).getMaxEnergyStored();
    }

    public int getBarWidth(@NotNull ItemStack itemStack) {
        return (int)Math.min(13L * this.getEnergyStorage(itemStack).getEnergyStored() / this.getEnergyStorage(itemStack).getMaxEnergyStored(), 13L);
    }

    public IPolyEnergyStorage getEnergyStorage(ItemStack stack) {
        return new PolyItemEnergyStorage(stack, (long)Shrink.shrinkConfig.shrinkingDeviceCapacity, 64L);
    }
}

