/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.particle;

import com.lothrazar.simpletomb.particle.TransparentParticle;
import java.util.Random;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public class ParticleGraveSmoke
extends TransparentParticle {
    final Random rand = new Random();
    private final SpriteSet spriteSet;
    protected final int halfMaxAge;
    protected final float alphaStep;
    private final float rotIncrement;

    private ParticleGraveSmoke(SpriteSet spriteSet, ClientLevel level, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(level, x, y + 0.1, z);
        this.xd = motionX;
        this.yd = motionY;
        this.zd = motionZ;
        this.alpha = 0.0f;
        this.scale(4.0f);
        this.roll = (float)Math.PI * 2 * this.rand.nextFloat();
        this.rotIncrement = (float)(Math.PI * (double)(this.rand.nextFloat() - 0.5f) * 0.01);
        this.setLifetime(80);
        this.halfMaxAge = this.lifetime / 2;
        this.alphaStep = 0.08f / (float)this.halfMaxAge;
        this.hasPhysics = false;
        this.setColor(0.0f, 0.5f, 0.1f);
        this.spriteSet = spriteSet;
        this.setSpriteFromAge(this.spriteSet);
    }

    public void tick() {
        super.tick();
        if (this.isAlive()) {
            this.setSpriteFromAge(this.spriteSet);
            this.oRoll = this.roll;
            this.roll += this.rotIncrement;
            this.setAlpha((float)Mth.clamp((int)(this.age < this.halfMaxAge ? this.age : this.lifetime - this.age), (int)0, (int)this.halfMaxAge) * this.alphaStep);
        }
    }

    protected int getLightColor(float partialTick) {
        int skylight = 8;
        int blocklight = 15;
        return skylight << 20 | blocklight << 4;
    }

    @Override
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double motionX, double motionY, double motionZ) {
            RandomSource rand = level == null ? RandomSource.createThreadSafe() : level.random;
            return new ParticleGraveSmoke(this.spriteSet, level, x, y + 0.4, z, (double)(rand.nextFloat() - 0.5f) * 0.03, 0.0, (double)(rand.nextFloat() - 0.5f) * 0.03);
        }
    }
}

