/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.event;

import com.lothrazar.simpletomb.ConfigTomb;
import com.lothrazar.simpletomb.ModTomb;
import com.lothrazar.simpletomb.TombRegistry;
import com.lothrazar.simpletomb.block.BlockEntityTomb;
import com.lothrazar.simpletomb.block.BlockTomb;
import com.lothrazar.simpletomb.data.DeathHelper;
import com.lothrazar.simpletomb.data.MessageType;
import com.lothrazar.simpletomb.data.PartEnum;
import com.lothrazar.simpletomb.data.PlayerTombRecords;
import com.lothrazar.simpletomb.helper.EntityHelper;
import com.lothrazar.simpletomb.helper.WorldHelper;
import com.lothrazar.simpletomb.item.GraveKeyItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDestroyBlockEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class PlayerTombEvents {
    public final Map<UUID, PlayerTombRecords> grv = new HashMap<UUID, PlayerTombRecords>();
    private static final String TOMB_FILE_EXT = ".mctomb";
    private static final String TB_SOULBOUND_STACKS = "tb_soulbound_stacks";
    private static final Map<UUID, List<ItemStack>> keepingMap = new HashMap<UUID, List<ItemStack>>();

    public PlayerTombRecords findGrave(UUID id) {
        if (this.grv.containsKey(id)) {
            return this.grv.get(id);
        }
        return null;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerLogged(PlayerEvent.PlayerLoggedInEvent event) {
        if (EntityHelper.isValidPlayerMP((Entity)event.getEntity())) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            assert (player.getServer() != null);
            CompoundTag playerData = player.getPersistentData();
            if (playerData.contains("PlayerPersisted")) {
                CompoundTag persistantData = playerData.getCompound("PlayerPersisted");
            } else {
                CompoundTag persistantData = new CompoundTag();
                playerData.put("PlayerPersisted", (Tag)persistantData);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDetonate(ExplosionEvent.Detonate event) {
        event.getAffectedBlocks().removeIf(blockPos -> event.getLevel().getBlockState(blockPos).getBlock() instanceof BlockTomb);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDestroy(LivingDestroyBlockEvent event) {
        if (event.getState().getBlock() instanceof BlockTomb && !(event.getEntity() instanceof Player)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (EntityHelper.isValidPlayerMP((Entity)player) && !player.isSpectator()) {
            CompoundTag persistentTag = EntityHelper.getPersistentTag(player);
            ListTag stackList = persistentTag.getList(TB_SOULBOUND_STACKS, 10);
            for (int i = 0; i < stackList.size(); ++i) {
                ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)player.registryAccess(), (CompoundTag)stackList.getCompound(i));
                if (stack.isEmpty()) continue;
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
            }
            persistentTag.remove(TB_SOULBOUND_STACKS);
            player.inventoryMenu.broadcastChanges();
        }
    }

    private void storeSoulboundsOnBody(Player player, List<ItemStack> keys) {
        CompoundTag persistentTag = EntityHelper.getPersistentTag(player);
        ListTag stackList = persistentTag.contains(TB_SOULBOUND_STACKS) ? persistentTag.getList(TB_SOULBOUND_STACKS, 10) : new ListTag();
        for (ItemStack key : keys) {
            stackList.add((Object)key.saveOptional((HolderLookup.Provider)player.registryAccess()));
        }
        persistentTag.put(TB_SOULBOUND_STACKS, (Tag)stackList);
        keys.clear();
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onLivingDeath(LivingDeathEvent event) {
        if (!EntityHelper.isValidPlayer((Entity)event.getEntity()) || WorldHelper.isRuleKeepInventory((Player)event.getEntity())) {
            return;
        }
        if (!event.isCanceled()) {
            Player player = (Player)event.getEntity();
            PartEnum part = (PartEnum)((Object)ConfigTomb.KEEPPARTS.get());
            switch (part) {
                case HOTBAR: {
                    ArrayList<ItemStack> hotbarStacks = new ArrayList<ItemStack>();
                    for (int i = 0; i < 9; ++i) {
                        hotbarStacks.add(i, (ItemStack)player.getInventory().items.get(i));
                    }
                    keepingMap.put(player.getUUID(), hotbarStacks);
                    break;
                }
                case ARMOR: {
                    ArrayList armorStacks = new ArrayList();
                    player.getInventory().armor.forEach(armorStacks::add);
                    keepingMap.put(player.getUUID(), armorStacks);
                    break;
                }
                case HOTBAR_AND_ARMOR: {
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                    for (int i = 0; i < 9; ++i) {
                        stacks.add(i, (ItemStack)player.getInventory().items.get(i));
                    }
                    player.getInventory().armor.forEach(stacks::add);
                    keepingMap.put(player.getUUID(), stacks);
                    break;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void onPlayerDrops(LivingDropsEvent event) {
        if (!((Boolean)ConfigTomb.TOMBENABLED.get()).booleanValue()) {
            return;
        }
        if (!EntityHelper.isValidPlayer((Entity)event.getEntity()) || WorldHelper.isRuleKeepInventory((Player)event.getEntity())) {
            return;
        }
        Player player = (Player)event.getEntity();
        List keepStacks = keepingMap.getOrDefault(player.getUUID(), new ArrayList());
        if (!keepStacks.isEmpty()) {
            event.getDrops().removeIf(entity -> keepStacks.contains(entity.getItem()));
            this.storeSoulboundsOnBody(player, keepStacks);
            keepingMap.remove(player.getUUID());
        }
        this.saveBackup(event);
        this.placeTombstone(event);
    }

    @SubscribeEvent
    public void onSaveFile(PlayerEvent.SaveToFile event) {
        Player player = event.getEntity();
        File mctomb = new File(event.getPlayerDirectory(), String.valueOf(player.getUUID()) + TOMB_FILE_EXT);
        if (this.grv.containsKey(player.getUUID())) {
            PlayerTombRecords dataToSave = this.grv.get(player.getUUID());
            CompoundTag data = dataToSave.write();
            try {
                FileOutputStream fileoutputstream = new FileOutputStream(mctomb);
                NbtIo.writeCompressed((CompoundTag)data, (OutputStream)fileoutputstream);
                fileoutputstream.close();
            }
            catch (IOException e) {
                ModTomb.LOGGER.error("IO", (Throwable)e);
            }
        }
    }

    @SubscribeEvent
    public void onLoadFile(PlayerEvent.LoadFromFile event) {
        Player player = event.getEntity();
        File mctomb = new File(event.getPlayerDirectory(), String.valueOf(player.getUUID()) + TOMB_FILE_EXT);
        if (mctomb.exists()) {
            try {
                FileInputStream fileinputstream = new FileInputStream(mctomb);
                CompoundTag data = NbtIo.readCompressed((InputStream)fileinputstream, (NbtAccounter)NbtAccounter.unlimitedHeap());
                fileinputstream.close();
                PlayerTombRecords dataLoaded = new PlayerTombRecords();
                dataLoaded.read(data, player.getUUID());
                if (this.grv.containsKey(player.getUUID())) {
                    this.grv.put(player.getUUID(), dataLoaded);
                } else {
                    this.grv.put(player.getUUID(), dataLoaded);
                }
            }
            catch (Exception e) {
                ModTomb.LOGGER.error("IO", (Throwable)e);
            }
        }
    }

    private void saveBackup(LivingDropsEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        Iterator it = event.getDrops().iterator();
        ListTag drops = new ListTag();
        boolean isEmpty = true;
        CompoundTag tombstoneTag = new CompoundTag();
        while (it.hasNext()) {
            ItemEntity entityItem = (ItemEntity)it.next();
            if (entityItem == null || entityItem.getItem().isEmpty()) continue;
            ItemStack stack = entityItem.getItem();
            drops.add((Object)stack.save((HolderLookup.Provider)event.getEntity().registryAccess(), (Tag)new CompoundTag()));
            if (stack.getItem() == TombRegistry.GRAVE_KEY.get()) continue;
            isEmpty = false;
        }
        if (!isEmpty) {
            tombstoneTag.putLong("timestamp", System.currentTimeMillis());
            tombstoneTag.put("drops", (Tag)drops);
            tombstoneTag.put("pos", NbtUtils.writeBlockPos((BlockPos)player.blockPosition()));
            tombstoneTag.putString("dimension", player.level().dimension().location().toString());
            UUID pid = player.getUUID();
            tombstoneTag.putString("playerid", pid.toString());
            tombstoneTag.putString("playername", player.getDisplayName().getString());
            if (this.grv.containsKey(pid)) {
                this.grv.get((Object)pid).playerGraves.add(tombstoneTag);
            } else {
                this.grv.put(pid, new PlayerTombRecords(pid, tombstoneTag));
            }
        }
    }

    private void placeTombstone(LivingDropsEvent event) {
        BlockEntityTomb grave;
        IItemHandler itemHandler;
        BlockState state;
        GlobalPos spawnPos;
        List<ItemEntity> itemsPickedUpFromGround;
        ArrayList<ItemStack> keys;
        ServerLevel level;
        ServerPlayer player;
        block13: {
            block12: {
                boolean hasDrop;
                player = (ServerPlayer)event.getEntity();
                level = player.serverLevel();
                Iterator it = event.getDrops().iterator();
                keys = new ArrayList<ItemStack>();
                while (it.hasNext()) {
                    ItemStack stack;
                    ItemEntity entityItem = (ItemEntity)it.next();
                    if (entityItem == null || entityItem.getItem().isEmpty() || (stack = entityItem.getItem()).getItem() != TombRegistry.GRAVE_KEY.get()) continue;
                    keys.add(stack.copy());
                    it.remove();
                }
                itemsPickedUpFromGround = this.pickupFromGround((Player)player, keys);
                this.storeSoulboundsOnBody((Player)player, keys);
                boolean bl = hasDrop = event.getDrops().size() > 0 || itemsPickedUpFromGround.size() > 0;
                if (!hasDrop) {
                    MessageType.MESSAGE_NO_LOOT_FOR_GRAVE.sendSpecialMessage((Player)player, new Object[0]);
                    return;
                }
                BlockPos initPos = WorldHelper.getInitialPos((Level)level, new BlockPos((Vec3i)player.blockPosition()));
                spawnPos = WorldHelper.findGraveSpawn((Player)player, initPos);
                if (spawnPos == null || spawnPos.pos() == null) {
                    MessageType.MESSAGE_NO_PLACE_FOR_GRAVE.sendSpecialMessage((Player)player, new Object[0]);
                    ModTomb.LOGGER.log(org.apache.logging.log4j.Level.INFO, MessageType.MESSAGE_NO_PLACE_FOR_GRAVE.getTranslation(new Object[0]));
                    return;
                }
                Direction facing = player.getDirection().getOpposite();
                state = PlayerTombEvents.getRandomGrave(level, facing);
                boolean wasPlaced = WorldHelper.placeGrave((Level)level, spawnPos.pos(), state);
                if (!wasPlaced) {
                    PlayerTombEvents.sendFailMessage(player);
                    return;
                }
                BlockEntity tile = level.getBlockEntity(spawnPos.pos());
                itemHandler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, spawnPos.pos(), null);
                if (!(tile instanceof BlockEntityTomb)) break block12;
                grave = (BlockEntityTomb)tile;
                if (itemHandler != null) break block13;
            }
            PlayerTombEvents.sendFailMessage(player);
            return;
        }
        grave.initTombstoneOwner((Player)player);
        if (((Boolean)ConfigTomb.KEYGIVEN.get()).booleanValue()) {
            ItemStack key = new ItemStack((ItemLike)TombRegistry.GRAVE_KEY.get());
            ((GraveKeyItem)((Object)TombRegistry.GRAVE_KEY.get())).setTombPos(key, spawnPos);
            PlayerTombEvents.setKeyName(player, key);
            keys.add(key);
        }
        this.storeSoulboundsOnBody((Player)player, keys);
        for (ItemEntity entityItem : event.getDrops()) {
            if (entityItem.getItem().isEmpty()) continue;
            ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)entityItem.getItem().copy(), (boolean)false);
            entityItem.setItem(ItemStack.EMPTY);
        }
        for (ItemEntity entityItem : itemsPickedUpFromGround) {
            ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)entityItem.getItem(), (boolean)false);
            entityItem.setItem(ItemStack.EMPTY);
        }
        level.sendBlockUpdated(spawnPos.pos(), state, state, 2);
        DeathHelper.INSTANCE.putLastGrave((Player)player, spawnPos);
        if (((Boolean)ConfigTomb.TOMBLOG.get()).booleanValue()) {
            ModTomb.LOGGER.info("{}{}", (Object)MessageType.MESSAGE_NEW_GRAVE.getTranslation(new Object[0]), (Object)String.format("(%d, %d, %d) " + String.valueOf(spawnPos.dimension()), spawnPos.pos().getX(), spawnPos.pos().getY(), spawnPos.pos().getZ()));
        }
        if (((Boolean)ConfigTomb.TOMBCHAT.get()).booleanValue()) {
            MessageType.MESSAGE_NEW_GRAVE.sendSpecialMessage((Player)player, String.format("(%d, %d, %d) " + WorldHelper.getDimensionName((ResourceKey<Level>)spawnPos.dimension()).getString(), spawnPos.pos().getX(), spawnPos.pos().getY(), spawnPos.pos().getZ()));
        }
    }

    public static void sendFailMessage(ServerPlayer player) {
        MessageType.MESSAGE_FAIL_TO_PLACE_GRAVE.sendSpecialMessage((Player)player, new Object[0]);
        ModTomb.LOGGER.log(org.apache.logging.log4j.Level.INFO, MessageType.MESSAGE_FAIL_TO_PLACE_GRAVE.getTranslation(new Object[0]));
    }

    public static void setKeyName(ServerPlayer player, ItemStack key) {
        PlayerTombEvents.putKeyName(player.getName().getString(), key);
    }

    public static void putKeyName(String player, ItemStack key) {
        if (((Boolean)ConfigTomb.KEYNAMED.get()).booleanValue()) {
            MutableComponent text = Component.translatable((String)player);
            text.append((Component)Component.literal((String)" "));
            text.append(key.getHoverName());
            text.withStyle(ChatFormatting.GOLD);
            key.set(DataComponents.CUSTOM_NAME, (Object)text);
        }
    }

    static BlockState getRandomGrave(ServerLevel serverLevel, Direction facing) {
        BlockTomb[] graves = new BlockTomb[]{(BlockTomb)((Object)TombRegistry.GRAVE_SIMPLE.get()), (BlockTomb)((Object)TombRegistry.GRAVE_NORMAL.get()), (BlockTomb)((Object)TombRegistry.GRAVE_CROSS.get()), (BlockTomb)((Object)TombRegistry.TOMBSTONE.get())};
        BlockState state = graves[serverLevel.random.nextInt(graves.length)].defaultBlockState();
        state = (BlockState)state.setValue(BlockTomb.FACING, (Comparable)facing);
        state = (BlockState)state.setValue((Property)BlockTomb.MODEL_TEXTURE, (Comparable)Integer.valueOf(serverLevel.random.nextInt(2)));
        return state;
    }

    private List<ItemEntity> pickupFromGround(Player player, ArrayList<ItemStack> keys) {
        double range = ((Integer)ConfigTomb.TOMBEXTRAITEMS.get()).intValue();
        if (range == 0.0) {
            return new ArrayList<ItemEntity>();
        }
        int posX = player.blockPosition().getX();
        int posY = player.blockPosition().getY();
        int posZ = player.blockPosition().getZ();
        return player.level().getEntitiesOfClass(ItemEntity.class, new AABB((double)posX - range, (double)posY - range, (double)posZ - range, (double)posX + range, (double)posY + range, (double)posZ + range));
    }
}

