/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.toolkit.utils;

import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public class EnchantmentHacks {
    public static void enchantItem(ItemStack stack, Holder.Reference<Enchantment> enchantment, short level) {
        ItemEnchantments enchantments = (ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS);
        ItemEnchantments.Mutable mutableEnchants = new ItemEnchantments.Mutable(Objects.requireNonNullElse(enchantments, ItemEnchantments.EMPTY));
        mutableEnchants.set(enchantment, (int)level);
        stack.set(DataComponents.ENCHANTMENTS, (Object)mutableEnchants.toImmutable());
    }

    public static boolean removeEnchantment(ItemStack stack, Holder.Reference<Enchantment> enchantment) {
        ItemEnchantments enchantments = (ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS);
        if (enchantments == null) {
            return false;
        }
        ItemEnchantments.Mutable mutableEnchants = new ItemEnchantments.Mutable(enchantments);
        for (Holder enchant : mutableEnchants.keySet()) {
            if (!((Enchantment)enchant.value()).equals(enchantment.value())) continue;
            mutableEnchants.set(enchantment, 0);
            stack.set(DataComponents.ENCHANTMENTS, (Object)mutableEnchants.toImmutable());
            return true;
        }
        return false;
    }
}

