/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.toolkit.jobs;

import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ServerTickJobRunner {
    INSTANCE;

    private static final Logger LOGGER;
    private final Queue<Runnable> queue = new ArrayDeque<Runnable>();
    private int tickCount = 0;

    public static ServerTickJobRunner get() {
        return INSTANCE;
    }

    public void add(Runnable job) {
        this.queue.add(job);
    }

    public void onTick(MinecraftServer server) {
        if (this.queue.isEmpty()) {
            if (this.tickCount > 0) {
                LOGGER.debug("Finished running jobs");
                this.tickCount = 0;
            }
            return;
        }
        ++this.tickCount;
        if (this.tickCount % 5 != 0) {
            return;
        }
        Runnable job = this.queue.poll();
        if (job == null) {
            return;
        }
        server.execute(() -> {
            try {
                job.run();
            }
            catch (Exception e) {
                LOGGER.error("Failed to run job", (Throwable)e);
            }
        });
    }

    static {
        LOGGER = LoggerFactory.getLogger(ServerTickJobRunner.class);
    }
}

