/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.toolkit.commands.player;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class TeleportDimensionSpawnCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"tpdim").requires(cs -> cs.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(ctx -> TeleportDimensionSpawnCommand.teleport((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).getServer(), List.of(((CommandSourceStack)ctx.getSource()).getPlayerOrException()), DimensionArgument.getDimension((CommandContext)ctx, (String)"dimension")))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.entities()).executes(ctx -> TeleportDimensionSpawnCommand.teleport((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).getServer(), EntityArgument.getEntities((CommandContext)ctx, (String)"target"), DimensionArgument.getDimension((CommandContext)ctx, (String)"dimension")))));
    }

    private static int teleport(CommandSourceStack source, MinecraftServer server, Collection<? extends Entity> entities, ServerLevel dimension) {
        ServerLevel level = server.getLevel(dimension.dimension());
        if (level == null) {
            source.sendFailure((Component)Component.literal((String)"Dimension not found"));
            return 0;
        }
        for (Entity entity : entities) {
            BlockPos pos = entity.blockPosition();
            if (!level.getWorldBorder().isWithinBounds(pos)) {
                pos = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, new BlockPos((int)level.getWorldBorder().getCenterX(), 0, (int)level.getWorldBorder().getCenterZ()));
            }
            int playerXp = 0;
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                playerXp = serverPlayer.experienceLevel;
                serverPlayer.teleportTo(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), entity.getYRot(), entity.getXRot());
                serverPlayer.setExperienceLevels(playerXp);
            } else {
                entity.teleportTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
            }
            if (!level.isLoaded(pos)) {
                level.getChunk(pos);
            }
            if (!(entity instanceof ServerPlayer)) continue;
            BlockState playerFeetBlock = level.getBlockState(pos);
            BlockState playerHeadBlock = level.getBlockState(pos.above());
            if (playerHeadBlock.isAir() && playerFeetBlock.isAir()) continue;
            BoundingBox box = new BoundingBox(pos).inflatedBy(1);
            BlockPos.betweenClosedStream((BoundingBox)box).forEach(blockPos -> {
                BlockState state = level.getBlockState(blockPos);
                if (!state.isAir()) {
                    level.setBlockAndUpdate(blockPos, Blocks.AIR.defaultBlockState());
                }
            });
        }
        return 1;
    }
}

