/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.toolkit.commands.level;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.sunekaer.toolkit.ToolkitPlatform;
import com.sunekaer.toolkit.jobs.ServerTickJobRunner;
import com.sunekaer.toolkit.utils.ChunkRangeIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ClearCommand {
    private static final AtomicBoolean COMPLETED = new AtomicBoolean(true);
    public static final ExecutorService EXECUTOR = Executors.newSingleThreadExecutor();

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"clear").requires(cs -> cs.hasPermission(2))).executes(context -> ClearCommand.remove((CommandSourceStack)context.getSource(), 1, RemovalPredicate.NAMES[0]))).then(((RequiredArgumentBuilder)Commands.argument((String)"range", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> ClearCommand.remove((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"range"), RemovalPredicate.NAMES[0]))).then(Commands.argument((String)"filter", (ArgumentType)StringArgumentType.string()).suggests((commandContext, suggestionsBuilder) -> SharedSuggestionProvider.suggest((String[])RemovalPredicate.NAMES, (SuggestionsBuilder)suggestionsBuilder)).executes(ctx -> ClearCommand.remove((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"range"), StringArgumentType.getString((CommandContext)ctx, (String)"filter")))));
    }

    private static int remove(CommandSourceStack source, int size, String filter) throws CommandSyntaxException {
        if (!COMPLETED.get()) {
            source.sendFailure((Component)Component.literal((String)"Already running, give it a second."));
            return 1;
        }
        COMPLETED.set(false);
        ServerPlayer player = source.getPlayerOrException();
        RemovalPredicate removalCheck = RemovalPredicate.getFromName(filter).orElse(RemovalPredicate.JUST_ORES);
        Predicate<BlockState> customCheck = null;
        if (filter.startsWith("#")) {
            customCheck = state -> state.is(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)filter.replace("#", ""))));
        } else if (filter.contains(":")) {
            customCheck = state -> BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()).toString().equalsIgnoreCase(filter);
        }
        ServerLevel level = source.getLevel();
        source.sendSuccess(() -> Component.translatable((String)"commands.toolkit.remove.lagwarring"), true);
        int range = size - 1;
        ChunkPos chunkPos = player.chunkPosition();
        Predicate<BlockState> finalCustomCheck = customCheck;
        COMPLETED.set(false);
        for (int x = chunkPos.x - range; x <= chunkPos.x + range; ++x) {
            for (int z = chunkPos.z - range; z <= chunkPos.z + range; ++z) {
                ChunkPos currentChunkPos = new ChunkPos(x, z);
                boolean shouldComplete = x == chunkPos.x + range && z == chunkPos.z + range;
                ServerTickJobRunner.get().add(() -> {
                    ClearCommand.removeChunk(level, currentChunkPos, finalCustomCheck != null ? finalCustomCheck : removalCheck.stateCheck);
                    if (shouldComplete) {
                        COMPLETED.set(true);
                    }
                });
            }
        }
        return 1;
    }

    private static void removeChunk(ServerLevel level, ChunkPos chunkPos, Predicate<BlockState> blockCheck) {
        int maxHeight;
        BlockState airState = Blocks.AIR.defaultBlockState();
        ChunkRangeIterator iterator = new ChunkRangeIterator((Level)level, chunkPos, 1, true);
        ArrayList<BlockPos> updatedBlocks = new ArrayList<BlockPos>();
        int n = maxHeight = level.dimension() == ServerLevel.NETHER ? 127 : level.getMaxBuildHeight();
        while (iterator.hasNext()) {
            BlockPos pos = iterator.next();
            BlockState state = level.getBlockState(pos);
            if (state.isAir() || state.getBlock() == Blocks.BEDROCK) {
                if (state.isAir() || pos.getY() <= level.getMinBuildHeight() || pos.getY() >= maxHeight) continue;
                level.setBlock(pos, airState, 2);
                updatedBlocks.add(pos);
                continue;
            }
            if (blockCheck.test(state)) continue;
            level.setBlock(pos, airState, 2);
            updatedBlocks.add(pos);
        }
        for (BlockPos pos : updatedBlocks) {
            level.blockUpdated(pos, airState.getBlock());
        }
    }

    private static enum RemovalPredicate {
        JUST_ORES(state -> state.is(ToolkitPlatform.getOresTag())),
        ORES_AND_MODDED(state -> state.is(ToolkitPlatform.getOresTag()) && BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()).getNamespace().equals("minecraft"));

        public static final List<RemovalPredicate> VALUES;
        public static final String[] NAMES;
        final Predicate<BlockState> stateCheck;

        private RemovalPredicate(Predicate<BlockState> stateCheck) {
            this.stateCheck = stateCheck;
        }

        public static Optional<RemovalPredicate> getFromName(String name) {
            return VALUES.stream().filter(e -> e.toString().toLowerCase().equals(name)).findFirst();
        }

        static {
            VALUES = Arrays.asList(RemovalPredicate.values());
            NAMES = (String[])VALUES.stream().map(e -> e.toString().toLowerCase()).toArray(String[]::new);
        }
    }
}

