/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.toolkit.commands.inventory;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.sunekaer.toolkit.commands.inventory.InventoryCollector;
import com.sunekaer.toolkit.network.SetCopy;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class PrintCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.literal((String)"print").then(Commands.argument((String)"type", (ArgumentType)StringArgumentType.word()).suggests(InventoryCollector::suggestions).executes(context -> PrintCommand.print((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"type"), false)));
    }

    private static int print(CommandContext<CommandSourceStack> context, String typeInput, boolean copyOnReply) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        InventoryCollector type = InventoryCollector.fromString(typeInput);
        if (type == null) {
            source.sendFailure((Component)Component.literal((String)"Invalid type"));
            return 0;
        }
        ServerPlayer player = source.getPlayerOrException();
        List<ItemStack> itemCollection = type.itemCollector.apply((Player)player);
        for (ItemStack stack : itemCollection) {
            String itemName = Objects.requireNonNull(stack.getItem().arch$registryName()).toString();
            List tags = stack.getTags().collect(Collectors.toList());
            String withNBT = "";
            Tag saveData = stack.save((HolderLookup.Provider)((CommandSourceStack)context.getSource()).registryAccess());
            if (saveData instanceof CompoundTag && ((CompoundTag)saveData).contains("components")) {
                Tag components = ((CompoundTag)saveData).get("components");
                assert (components != null);
                withNBT = components.toString();
            }
            String combinedItemNBT = itemName + withNBT;
            source.sendSuccess(() -> Component.literal((String)combinedItemNBT).withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, combinedItemNBT)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Copy tag"))).withColor(ChatFormatting.YELLOW)), false);
            if (copyOnReply) {
                NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SetCopy(combinedItemNBT));
            }
            if (tags.isEmpty()) continue;
            for (TagKey tag : tags) {
                String tagString = String.format("#%s", tag.location());
                source.sendSuccess(() -> Component.literal((String)"- ").append((Component)Component.literal((String)tagString).withStyle(Style.EMPTY.withColor(ChatFormatting.RED).withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, tagString)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Copy tag"))))), false);
            }
        }
        return 1;
    }

    public static ArgumentBuilder<CommandSourceStack, ?> registerHandCommand() {
        return Commands.literal((String)"hand").executes(context -> PrintCommand.print((CommandContext<CommandSourceStack>)context, "hand", true));
    }
}

