/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.impl.command;

import com.google.gson.Gson;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.darkhax.bookshelf.common.api.commands.IEnumCommand;
import net.darkhax.bookshelf.common.api.data.codecs.map.MapCodecs;
import net.darkhax.bookshelf.common.api.util.CommandHelper;
import net.darkhax.bookshelf.common.api.util.TextHelper;
import net.darkhax.bookshelf.common.impl.Constants;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public enum HandCommand implements IEnumCommand
{
    ID((stack, level) -> TextHelper.copyText(Objects.requireNonNull(level.registryAccess().registryOrThrow(Registries.ITEM).getKey((Object)stack.getItem())).toString())),
    STRING((stack, level) -> TextHelper.copyText(stack.toString())),
    INGREDIENT(HandCommand.json(MapCodecs.INGREDIENT.get(), (stack, level) -> Ingredient.of((ItemStack[])new ItemStack[]{stack}))),
    STACK_JSON(HandCommand.json(MapCodecs.ITEM_STACK.get(), (stack, level) -> stack)),
    STACK_NBT(HandCommand.nbt(MapCodecs.ITEM_STACK.get(), (stack, level) -> stack)),
    COMPONENTS((stack, level) -> {
        StringJoiner joiner = new StringJoiner("\n");
        stack.getComponents().stream().sorted(Comparator.comparing(r -> r.type().toString())).forEach(component -> joiner.add(String.valueOf(component.type()) + " = " + String.valueOf(HandCommand.unsafeEncode(Objects.requireNonNull(component.type().codec()), NbtOps.INSTANCE, component.value()))));
        return TextHelper.copyText(joiner.toString());
    }),
    TAGS((stack, level) -> {
        StringJoiner joiner = new StringJoiner("\n");
        stack.getTags().map(key -> key.location().toString()).sorted().forEach(joiner::add);
        return TextHelper.copyText(joiner.toString());
    });

    private final ItemFormat format;

    private HandCommand(ItemFormat format) {
        this.format = format;
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> this.format.formatItem(living.getMainHandItem(), source.getLevel()), false);
        }
        return 1;
    }

    private static <T> ItemFormat json(Codec<T> codec, BiFunction<ItemStack, ServerLevel, T> mapper) {
        return HandCommand.fromCodec(JsonOps.INSTANCE, arg_0 -> ((Gson)Constants.GSON_PRETTY).toJson(arg_0), codec, mapper);
    }

    private static <T> ItemFormat nbt(Codec<T> codec, BiFunction<ItemStack, ServerLevel, T> mapper) {
        return HandCommand.fromCodec(NbtOps.INSTANCE, Tag::toString, codec, mapper);
    }

    private static <T, D> ItemFormat fromCodec(DynamicOps<D> ops, Function<D, String> dataFormatter, Codec<T> codec, BiFunction<ItemStack, ServerLevel, T> mapper) {
        return (stack, level) -> {
            if (stack.isEmpty()) {
                return Component.translatable((String)"commands.bookshelf.hand.error.not_air").withStyle(ChatFormatting.RED);
            }
            Object value = mapper.apply(stack, level);
            Object data = codec.encodeStart((DynamicOps)RegistryOps.create((DynamicOps)ops, (HolderLookup.Provider)level.registryAccess()), value).getOrThrow();
            return TextHelper.copyText((String)dataFormatter.apply(data));
        };
    }

    private static <T> T unsafeEncode(Codec codec, DynamicOps<T> ops, Object input) {
        return (T)codec.encodeStart(ops, input).getOrThrow();
    }

    @Override
    public String getCommandName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static LiteralArgumentBuilder<CommandSourceStack> build(CommandBuildContext context) {
        return CommandHelper.buildFromEnum("hand", HandCommand.class);
    }

    static interface ItemFormat {
        public Component formatItem(ItemStack var1, ServerLevel var2);
    }
}

