/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.api.registry.register;

import java.util.function.BiConsumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public record RegisterItem(String owner, BiConsumer<ResourceLocation, Item> registerFunc) {
    public void addBlock(Block block) {
        ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
        if (!id.getNamespace().equals(this.owner)) {
            throw new IllegalArgumentException("You can only register item blocks for blocks in your namespace!");
        }
        this.add(id.getPath(), (Item)new BlockItem(block, new Item.Properties()));
    }

    public void add(String path) {
        this.add(path, new Item.Properties());
    }

    public void add(String path, Item.Properties properties) {
        this.add(path, new Item(properties));
    }

    public void add(String path, Item item) {
        this.registerFunc.accept(ResourceLocation.fromNamespaceAndPath((String)this.owner, (String)path), item);
    }
}

