/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.api.data.codecs.stream;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class StreamCodecs {
    public static final StreamCodec<RegistryFriendlyByteBuf, String> STRING = StreamCodec.of(FriendlyByteBuf::writeUtf, FriendlyByteBuf::readUtf);

    public static <B extends ByteBuf, V> StreamCodec<B, List<V>> list(StreamCodec<B, V> baseCodec) {
        return StreamCodec.of((buf, val) -> {
            buf.writeInt(val.size());
            for (Object entry : val) {
                baseCodec.encode(buf, entry);
            }
        }, buf -> {
            int size = buf.readInt();
            ArrayList<Object> list = new ArrayList<Object>(size);
            for (int i = 0; i < size; ++i) {
                list.add(baseCodec.decode(buf));
            }
            return list;
        });
    }
}

