/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplylight.data;

import com.flanks255.simplylight.SLBlockReg;
import com.flanks255.simplylight.SLBlocks;
import com.flanks255.simplylight.blocks.BaseBlockItem;
import com.flanks255.simplylight.blocks.EdgeLight;
import com.flanks255.simplylight.blocks.Fixture;
import com.flanks255.simplylight.blocks.LampBlock;
import com.flanks255.simplylight.blocks.LampPost;
import com.flanks255.simplylight.blocks.LampPostItem;
import com.flanks255.simplylight.blocks.LightBulb;
import com.flanks255.simplylight.blocks.RodLamp;
import com.flanks255.simplylight.blocks.ThinLamp;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.client.model.generators.loaders.CompositeModelBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class BlockStates
extends BlockStateProvider {
    ExistingFileHelper existingFileHelper;

    public BlockStates(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen.getPackOutput(), "simplylight", exFileHelper);
        this.existingFileHelper = exFileHelper;
    }

    protected void registerStatesAndModels() {
        this.generateLampBlockModels();
        SLBlocks.LAMPBLOCKS_ON.forEach(this::generateLampBlock);
        SLBlocks.LAMPBLOCKS_OFF.forEach(this::generateLampBlock);
        SLBlocks.SLABS.forEach(this::generateSlab);
        SLBlocks.PANELS.forEach(this::generatePanel);
        SLBlocks.RODS.forEach(this::generateRodLamp);
        SLBlocks.BULBS.forEach(this::generateLightBulb);
        SLBlocks.FIXTURES.forEach(this::generateWallLamp);
        SLBlocks.POSTS.forEach(this::generateLampPost);
        SLBlocks.EDGE_LIGHTS.forEach(this::generateEdgeBlock);
        SLBlocks.EDGE_LIGHTS_TOP.forEach(this::generateTopEdgeBlock);
    }

    private void generateLampBlockModels() {
        for (DyeColor color : DyeColor.values()) {
            ResourceLocation onTex;
            ResourceLocation offTex;
            if (color == DyeColor.WHITE) {
                offTex = this.modLoc("block/full_block/illuminant_block");
                onTex = this.modLoc("block/full_block/illuminant_block_on");
                ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/illuminant_block", "cube")).texture("all", offTex)).texture("particle", offTex)).ao(false)).element().cube("#all").shade(false).end();
                ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/illuminant_block_on", "cube")).texture("all", onTex)).texture("particle", onTex)).ao(false)).element().cube("#all").shade(false).end();
                continue;
            }
            offTex = this.modLoc("block/full_block/illuminant_" + color.getName() + "_block");
            onTex = this.modLoc("block/full_block/illuminant_" + color.getName() + "_block_on");
            ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/illuminant_" + color.getName() + "_block", this.modLoc("block/illuminant_block"))).texture("all", offTex)).texture("particle", offTex);
            ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/illuminant_" + color.getName() + "_block_on", this.modLoc("block/illuminant_block"))).texture("all", onTex)).texture("particle", onTex);
        }
    }

    private void generateLampBlock(SLBlockReg<LampBlock, BaseBlockItem> block) {
        ModelFile.ExistingModelFile onModel;
        ModelFile.ExistingModelFile offModel;
        DyeColor color = block.getBlock().color;
        if (color == DyeColor.WHITE) {
            offModel = this.models().getExistingFile(this.modLoc("block/illuminant_block"));
            onModel = this.models().getExistingFile(this.modLoc("block/illuminant_block_on"));
        } else {
            offModel = this.models().getExistingFile(this.modLoc("block/illuminant_" + color.getName() + "_block"));
            onModel = this.models().getExistingFile(this.modLoc("block/illuminant_" + color.getName() + "_block_on"));
        }
        VariantBlockStateBuilder LampBlockBuilder = this.getVariantBuilder(block.get());
        LampBlockBuilder.partialState().with((Property)LampBlock.ON, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)onModel).addModel();
        LampBlockBuilder.partialState().with((Property)LampBlock.ON, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)offModel).addModel();
    }

    private void generateLightBulb(SLBlockReg<LightBulb, BaseBlockItem> block) {
        ModelFile.ExistingModelFile glow;
        ModelFile.ExistingModelFile base;
        boolean isWhite;
        DyeColor color = block.getBlock().color;
        boolean bl = isWhite = color == DyeColor.WHITE;
        if (isWhite) {
            base = this.models().getExistingFile(this.modLoc("block/lightbulb_base"));
            glow = this.models().getExistingFile(this.modLoc("block/lightbulb_glow"));
        } else {
            ResourceLocation tex = this.modLoc("block/omni/omni_" + color.getName());
            base = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/lightbulb_base_" + color.getName(), this.modLoc("block/lightbulb_base"))).texture("main", tex)).texture("particle", tex);
            glow = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/lightbulb_glow_" + color.getName(), this.modLoc("block/lightbulb_glow"))).texture("main", tex)).texture("particle", tex);
        }
        BlockModelBuilder model = (BlockModelBuilder)((CompositeModelBuilder)((BlockModelBuilder)this.models().getBuilder((String)(isWhite ? "block/lightbulb" : "block/lightbulb_" + block.getBlock().color.getName()))).customLoader(CompositeModelBuilder::begin)).child("Solid", (ModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().nested()).renderType("minecraft:solid")).parent((ModelFile)base))).child("Translucent", (ModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().nested()).renderType("minecraft:translucent")).parent((ModelFile)glow))).end();
        model.texture("particle", isWhite ? this.modLoc("block/omni") : this.modLoc("block/omni/omni_" + color.getName()));
        this.myDirectionalBlock(block.get(), $ -> model, 180);
    }

    private void generateEdgeBlock(SLBlockReg<EdgeLight, BaseBlockItem> block) {
        ModelFile.ExistingModelFile model;
        DyeColor color = block.getBlock().color;
        if (color == DyeColor.WHITE) {
            model = this.models().getExistingFile(this.modLoc("block/edge_light"));
        } else {
            ResourceLocation tex = this.modLoc("block/omni/omni_" + color.getName());
            model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/edge_light_" + color.getName(), this.modLoc("block/edge_light"))).texture("0", tex)).texture("particle", tex);
        }
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(block.get());
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)model).addModel()).useOr().nestedGroup().condition((Property)EdgeLight.NORTH, (Comparable[])new Boolean[]{true}).end().nestedGroup().condition((Property)EdgeLight.NORTH, (Comparable[])new Boolean[]{false}).condition((Property)EdgeLight.SOUTH, (Comparable[])new Boolean[]{false}).condition((Property)EdgeLight.EAST, (Comparable[])new Boolean[]{false}).condition((Property)EdgeLight.WEST, (Comparable[])new Boolean[]{false}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)model).rotationY(180).addModel()).useOr().nestedGroup().condition((Property)EdgeLight.SOUTH, (Comparable[])new Boolean[]{true}).end().nestedGroup().condition((Property)EdgeLight.NORTH, (Comparable[])new Boolean[]{false}).condition((Property)EdgeLight.SOUTH, (Comparable[])new Boolean[]{false}).condition((Property)EdgeLight.EAST, (Comparable[])new Boolean[]{false}).condition((Property)EdgeLight.WEST, (Comparable[])new Boolean[]{false}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)model).rotationY(90).addModel()).useOr().nestedGroup().condition((Property)EdgeLight.EAST, (Comparable[])new Boolean[]{true}).end().nestedGroup().condition((Property)EdgeLight.NORTH, (Comparable[])new Boolean[]{false}).condition((Property)EdgeLight.SOUTH, (Comparable[])new Boolean[]{false}).condition((Property)EdgeLight.EAST, (Comparable[])new Boolean[]{false}).condition((Property)EdgeLight.WEST, (Comparable[])new Boolean[]{false}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)model).rotationY(270).addModel()).useOr().nestedGroup().condition((Property)EdgeLight.WEST, (Comparable[])new Boolean[]{true}).end().nestedGroup().condition((Property)EdgeLight.NORTH, (Comparable[])new Boolean[]{false}).condition((Property)EdgeLight.SOUTH, (Comparable[])new Boolean[]{false}).condition((Property)EdgeLight.EAST, (Comparable[])new Boolean[]{false}).condition((Property)EdgeLight.WEST, (Comparable[])new Boolean[]{false}).end();
    }

    private void generateTopEdgeBlock(SLBlockReg<EdgeLight, BaseBlockItem> block) {
        DyeColor color = block.getBlock().color;
        ModelFile.ExistingModelFile model = color == DyeColor.WHITE ? this.models().getExistingFile(this.modLoc("block/edge_light")) : this.models().getExistingFile(this.modLoc("block/edge_light_" + color.getName()));
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(block.get());
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)model).rotationY(180).rotationX(180).addModel()).useOr().nestedGroup().condition((Property)EdgeLight.NORTH, (Comparable[])new Boolean[]{true}).end().nestedGroup().condition((Property)EdgeLight.NORTH, (Comparable[])new Boolean[]{false}).condition((Property)EdgeLight.SOUTH, (Comparable[])new Boolean[]{false}).condition((Property)EdgeLight.EAST, (Comparable[])new Boolean[]{false}).condition((Property)EdgeLight.WEST, (Comparable[])new Boolean[]{false}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)model).rotationX(180).addModel()).useOr().nestedGroup().condition((Property)EdgeLight.SOUTH, (Comparable[])new Boolean[]{true}).end().nestedGroup().condition((Property)EdgeLight.NORTH, (Comparable[])new Boolean[]{false}).condition((Property)EdgeLight.SOUTH, (Comparable[])new Boolean[]{false}).condition((Property)EdgeLight.EAST, (Comparable[])new Boolean[]{false}).condition((Property)EdgeLight.WEST, (Comparable[])new Boolean[]{false}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)model).rotationY(270).rotationX(180).addModel()).useOr().nestedGroup().condition((Property)EdgeLight.EAST, (Comparable[])new Boolean[]{true}).end().nestedGroup().condition((Property)EdgeLight.NORTH, (Comparable[])new Boolean[]{false}).condition((Property)EdgeLight.SOUTH, (Comparable[])new Boolean[]{false}).condition((Property)EdgeLight.EAST, (Comparable[])new Boolean[]{false}).condition((Property)EdgeLight.WEST, (Comparable[])new Boolean[]{false}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)model).rotationY(90).rotationX(180).addModel()).useOr().nestedGroup().condition((Property)EdgeLight.WEST, (Comparable[])new Boolean[]{true}).end().nestedGroup().condition((Property)EdgeLight.NORTH, (Comparable[])new Boolean[]{false}).condition((Property)EdgeLight.SOUTH, (Comparable[])new Boolean[]{false}).condition((Property)EdgeLight.EAST, (Comparable[])new Boolean[]{false}).condition((Property)EdgeLight.WEST, (Comparable[])new Boolean[]{false}).end();
    }

    private void generateLampPost(SLBlockReg<LampPost, LampPostItem> block) {
        ModelFile.ExistingModelFile top;
        ModelFile.ExistingModelFile base = this.models().getExistingFile(this.modLoc("block/post_base"));
        ModelFile.ExistingModelFile mid = this.models().getExistingFile(this.modLoc("block/post_mid"));
        DyeColor color = block.getBlock().color;
        if (color == DyeColor.WHITE) {
            top = this.models().getExistingFile(this.modLoc("block/post_top"));
        } else {
            ResourceLocation tex = this.modLoc("block/post/post_lightface_" + color.getName());
            top = ((BlockModelBuilder)this.models().withExistingParent("block/post_top_" + color.getName(), this.modLoc("block/post_top"))).texture("1", tex);
            ((BlockModelBuilder)this.models().withExistingParent("block/lamp_post_item_" + color.getName(), this.modLoc("block/lamp_post_item"))).texture("3_1", tex);
        }
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block.get()).partialState().with(LampPost.POSITION, (Comparable)((Object)LampPost.Position.BOTTOM)).modelForState().modelFile((ModelFile)base).addModel()).partialState().with(LampPost.POSITION, (Comparable)((Object)LampPost.Position.MIDDLE)).modelForState().modelFile((ModelFile)mid).addModel()).partialState().with(LampPost.POSITION, (Comparable)((Object)LampPost.Position.TOP)).modelForState().modelFile((ModelFile)top).addModel();
    }

    private void generateWallLamp(SLBlockReg<Fixture, BaseBlockItem> block) {
        ModelFile.ExistingModelFile floorModel;
        ModelFile.ExistingModelFile wallModel;
        DyeColor color = block.getBlock().color;
        if (color == DyeColor.WHITE) {
            wallModel = this.models().getExistingFile(this.modLoc("block/wall_lamp"));
            floorModel = this.models().getExistingFile(this.modLoc("block/floor_lamp"));
        } else {
            ResourceLocation tex = this.modLoc("block/omni/omni_" + color.getName());
            wallModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/wall_lamp_" + color.getName(), this.modLoc("block/wall_lamp"))).texture("0", tex)).texture("particle", tex);
            floorModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/floor_lamp_" + color.getName(), this.modLoc("block/floor_lamp"))).texture("0", tex)).texture("particle", tex);
        }
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block.get()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).modelForState().modelFile((ModelFile)floorModel).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).modelForState().modelFile((ModelFile)floorModel).rotationX(180).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)wallModel).rotationY(270).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)wallModel).rotationY(90).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)wallModel).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)wallModel).rotationY(180).addModel();
    }

    private void generateSlab(SLBlockReg<ThinLamp, BaseBlockItem> block) {
        DyeColor color = block.getBlock().color;
        if (color == DyeColor.WHITE) {
            this.myDirectionalBlock(block.get(), $ -> this.models().getExistingFile(this.modLoc("block/illuminant_slab")), 180);
        } else {
            ResourceLocation tex = this.modLoc("block/slab/illuminant_slab_" + color.getName());
            ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent("block/illuminant_slab_" + color.getName(), this.modLoc("block/illuminant_slab"))).texture("up", tex);
            this.myDirectionalBlock(block.get(), arg_0 -> BlockStates.lambda$generateSlab$2((ModelFile)model, arg_0), 180);
        }
    }

    private void generatePanel(SLBlockReg<ThinLamp, BaseBlockItem> block) {
        DyeColor color = block.getBlock().color;
        if (color == DyeColor.WHITE) {
            this.myDirectionalBlock(block.get(), $ -> this.models().getExistingFile(this.modLoc("block/illuminant_panel")), 180);
        } else {
            ResourceLocation tex = this.modLoc("block/panel/illuminant_panel_" + color.getName());
            ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent("block/illuminant_panel_" + color.getName(), this.modLoc("block/illuminant_panel"))).texture("up", tex);
            this.myDirectionalBlock(block.get(), arg_0 -> BlockStates.lambda$generatePanel$4((ModelFile)model, arg_0), 180);
        }
    }

    void generateRodLamp(SLBlockReg<RodLamp, BaseBlockItem> block) {
        ModelFile.ExistingModelFile model;
        DyeColor color = block.getBlock().color;
        if (color == DyeColor.WHITE) {
            model = this.models().getExistingFile(this.modLoc("block/rodlamp"));
        } else {
            ResourceLocation tex = this.modLoc("block/omni/omni2_" + color.getName());
            model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/rodlamp_" + color.getName(), this.modLoc("block/rodlamp"))).texture("all", tex)).texture("particle", tex);
        }
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block.getBlock()).partialState().with((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Y).modelForState().modelFile((ModelFile)model).addModel()).partialState().with((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Z).modelForState().modelFile((ModelFile)model).rotationX(90).addModel()).partialState().with((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.X).modelForState().modelFile((ModelFile)model).rotationX(90).rotationY(90).addModel();
    }

    public void myDirectionalBlock(Block block, Function<BlockState, ModelFile> modelFunc, int angleOffset) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            Direction dir = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationX(dir == Direction.DOWN ? 180 : (dir.getAxis().isHorizontal() ? 90 : 0)).rotationY(dir.getAxis().isVertical() ? 0 : ((int)dir.toYRot() + angleOffset) % 360).build();
        }, new Property[]{BlockStateProperties.WATERLOGGED});
    }

    private static /* synthetic */ ModelFile lambda$generatePanel$4(ModelFile model, BlockState $) {
        return model;
    }

    private static /* synthetic */ ModelFile lambda$generateSlab$2(ModelFile model, BlockState $) {
        return model;
    }
}

