/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplylight.blocks;

import com.flanks255.simplylight.blocks.LampBase;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RodLamp
extends LampBase
implements SimpleWaterloggedBlock {
    public final DyeColor color;
    private final VoxelShape UpDown = Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private final VoxelShape EastWest = Block.box((double)0.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0);
    private final VoxelShape NorthSouth = Block.box((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)16.0);

    public RodLamp(DyeColor color) {
        super(BlockBehaviour.Properties.of().pushReaction(PushReaction.NORMAL).mapColor(MapColor.TERRACOTTA_WHITE).strength(1.0f).lightLevel($ -> 15));
        this.color = color;
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    public VoxelShape getShape(BlockState pState, @Nonnull BlockGetter pLevel, @Nonnull BlockPos pPos, @Nonnull CollisionContext pContext) {
        return switch ((Direction.Axis)pState.getValue((Property)BlockStateProperties.AXIS)) {
            case Direction.Axis.X -> this.EastWest;
            case Direction.Axis.Y -> this.UpDown;
            default -> this.NorthSouth;
        };
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext placeContext) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)placeContext.getClickedFace().getAxis())).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false));
    }

    public boolean canPlaceLiquid(Player player, @Nonnull BlockGetter pLevel, @Nonnull BlockPos pPos, @Nonnull BlockState pState, @Nonnull Fluid pFluid) {
        return true;
    }

    @Nonnull
    public FluidState getFluidState(BlockState p_204507_1_) {
        return (Boolean)p_204507_1_.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(p_204507_1_);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.add(new Property[]{BlockStateProperties.AXIS, BlockStateProperties.WATERLOGGED});
    }

    public boolean isPathfindable(@Nonnull BlockState pState, @Nonnull PathComputationType pType) {
        return false;
    }

    @Nonnull
    public BlockState rotate(@Nonnull BlockState pState, @Nonnull Rotation pRotation) {
        if (pRotation != Rotation.NONE) {
            Direction.Axis axis = (Direction.Axis)pState.getValue((Property)BlockStateProperties.AXIS);
            if ((pRotation == Rotation.CLOCKWISE_90 || pRotation == Rotation.COUNTERCLOCKWISE_90) && axis.isHorizontal()) {
                return (BlockState)pState.setValue((Property)BlockStateProperties.AXIS, (Comparable)(axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X));
            }
        }
        return pState;
    }

    @Override
    public void addLang(BiConsumer<String, String> consumer) {
        String colorname;
        String base = this.getDescriptionId();
        switch (this.color) {
            case RED: {
                String string = "Red";
                break;
            }
            case BLUE: {
                String string = "Blue";
                break;
            }
            case CYAN: {
                String string = "Cyan";
                break;
            }
            case GRAY: {
                String string = "Gray";
                break;
            }
            case LIME: {
                String string = "Lime";
                break;
            }
            case MAGENTA: {
                String string = "Magenta";
                break;
            }
            case PINK: {
                String string = "Pink";
                break;
            }
            case BLACK: {
                String string = "Black";
                break;
            }
            case BROWN: {
                String string = "Brown";
                break;
            }
            case GREEN: {
                String string = "Green";
                break;
            }
            case ORANGE: {
                String string = "Orange";
                break;
            }
            case PURPLE: {
                String string = "Purple";
                break;
            }
            case YELLOW: {
                String string = "Yellow";
                break;
            }
            case LIGHT_BLUE: {
                String string = "Light Blue";
                break;
            }
            case LIGHT_GRAY: {
                String string = "Light Gray";
                break;
            }
            default: {
                String string = colorname = "";
            }
        }
        if (this.color == DyeColor.WHITE) {
            consumer.accept(base, "Illuminant Rod");
        } else {
            consumer.accept(base, "Illuminant " + colorname + " Rod");
        }
        if (this.color != DyeColor.WHITE) {
            return;
        }
        consumer.accept(base + ".info", "A simple rod of light.");
        consumer.accept(base + ".info2", "Can be placed in any direction.");
    }
}

