/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.util.data;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.WithConditions;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public abstract class DynamicRegistryProvider<R extends CodecProvider<R>>
implements DataProvider {
    protected final CompletableFuture<HolderLookup.Provider> lookupProvider;
    protected final PackOutput.PathProvider pathProvider;
    protected final DynamicRegistry<R> registry;
    protected final List<CompletableFuture<?>> futures = new ArrayList();
    private CachedOutput cachedOutput;
    private DynamicRegistry.DataGenPopulator<R> populator;

    public DynamicRegistryProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, DynamicRegistry<R> registry) {
        this.lookupProvider = registries;
        this.pathProvider = output.createPathProvider(PackOutput.Target.DATA_PACK, registry.getPath());
        this.registry = registry;
    }

    @Deprecated(forRemoval=true)
    public DynamicRegistryProvider(GatherDataEvent event, DynamicRegistry<R> registry) {
        this.lookupProvider = event.getLookupProvider();
        this.pathProvider = event.getGenerator().getPackOutput().createPathProvider(PackOutput.Target.DATA_PACK, registry.getPath());
        this.registry = registry;
    }

    public final CompletableFuture<?> run(CachedOutput pOutput) {
        this.cachedOutput = pOutput;
        DynamicRegistry.DataGenPopulator.runScoped(this.registry, populator -> {
            this.populator = populator;
            this.generate();
            this.populator = null;
        });
        return CompletableFuture.allOf((CompletableFuture[])this.futures.toArray(CompletableFuture[]::new));
    }

    protected final void add(ResourceLocation id, R object) {
        this.populator.register(id, object);
        this.futures.add((CompletableFuture<?>)this.lookupProvider.thenCompose(regs -> {
            RegistryOps ops = regs.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
            return DataProvider.saveStable((CachedOutput)this.cachedOutput, (JsonElement)((JsonElement)this.registry.elementCodec().encodeStart((DynamicOps)ops, (Object)object).getOrThrow()), (Path)this.pathProvider.json(id));
        }));
    }

    protected final void addConditionally(ResourceLocation id, R object, ICondition ... conditions) {
        this.populator.register(id, object);
        Codec conditionalCodec = ConditionalOps.createConditionalCodecWithConditions(this.registry.elementCodec());
        this.futures.add((CompletableFuture<?>)this.lookupProvider.thenCompose(regs -> {
            RegistryOps ops = regs.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
            Optional<WithConditions> withConds = Optional.of(new WithConditions(Arrays.asList(conditions), (Object)object));
            return DataProvider.saveStable((CachedOutput)this.cachedOutput, (JsonElement)((JsonElement)conditionalCodec.encodeStart((DynamicOps)ops, withConds).getOrThrow()), (Path)this.pathProvider.json(id));
        }));
    }

    public abstract void generate();
}

