/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.modifiers.item.predicates;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.util.Serializer;
import com.supermartijn642.fusion.model.modifiers.item.predicates.ItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.ItemPredicateRegistry;
import net.minecraft.world.item.ItemStack;

public class NotItemPredicate
implements ItemPredicate {
    public static final Serializer<NotItemPredicate> SERIALIZER = new Serializer<NotItemPredicate>(){

        @Override
        public NotItemPredicate deserialize(JsonObject json) throws JsonParseException {
            if (!json.has("predicate") || !json.get("predicate").isJsonObject()) {
                throw new JsonParseException("Not-predicate must have object property 'predicate'!");
            }
            ItemPredicate predicate = ItemPredicateRegistry.deserializeItemPredicate(json.getAsJsonObject("predicate"));
            return new NotItemPredicate(predicate);
        }

        @Override
        public JsonObject serialize(NotItemPredicate value) {
            JsonObject json = new JsonObject();
            json.add("predicates", (JsonElement)ItemPredicateRegistry.serializeItemPredicate(value.predicate));
            return json;
        }
    };
    private final ItemPredicate predicate;

    public NotItemPredicate(ItemPredicate predicate) {
        this.predicate = predicate;
    }

    @Override
    public boolean test(ItemStack stack) {
        return !this.predicate.test(stack);
    }

    @Override
    public Serializer<? extends ItemPredicate> getSerializer() {
        return SERIALIZER;
    }
}

