/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.api;

import java.util.List;
import java.util.Map;
import speiger.src.collections.objects.lists.ObjectArrayList;
import speiger.src.collections.objects.maps.interfaces.Object2ObjectMap;

public interface IEntrySettings {
    default public <T> T get(Class<T> clz) {
        return clz.isInstance(this) ? (T)clz.cast(this) : null;
    }

    public static IEntrySettings compound(IEntrySettings ... settings) {
        return new CompoundEntrySettings((List<IEntrySettings>)ObjectArrayList.wrap((Object[])settings));
    }

    public static class CompoundEntrySettings
    implements IEntrySettings {
        Map<Class<?>, IEntrySettings> settings = Object2ObjectMap.builder().map();

        public CompoundEntrySettings(List<IEntrySettings> settings) {
            for (IEntrySettings setting : settings) {
                this.settings.put(setting.getClass(), setting);
            }
        }

        public CompoundEntrySettings(Map<Class<?>, IEntrySettings> settings) {
            this.settings.putAll(settings);
        }

        @Override
        public <T> T get(Class<T> clz) {
            IEntrySettings setting = this.settings.get(clz);
            return setting == null ? null : (T)clz.cast(setting);
        }
    }
}

