/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.api;

import carbonconfiglib.api.buffer.IReadBuffer;
import carbonconfiglib.api.buffer.IWriteBuffer;
import carbonconfiglib.utils.ParseResult;
import carbonconfiglib.utils.ParsedCollections;
import carbonconfiglib.utils.structure.StructureCompound;
import java.util.function.BiConsumer;
import java.util.function.Function;

public interface IConfigSerializer<T> {
    public T getExample();

    public StructureCompound.CompoundData getFormat();

    public ParseResult<Boolean> isValid(T var1);

    public ParseResult<T> deserialize(ParsedCollections.ParsedMap var1);

    public ParsedCollections.ParsedMap serialize(T var1);

    public T deserialize(IReadBuffer var1);

    public void serialize(IWriteBuffer var1, T var2);

    public static <T> IConfigSerializer<T> noSync(StructureCompound.CompoundData format, T example, Function<ParsedCollections.ParsedMap, ParseResult<T>> reader, Function<T, ParsedCollections.ParsedMap> writer) {
        return new FunctionWriter<T>(format, example, reader, writer, null, null, null);
    }

    public static <T> IConfigSerializer<T> noSync(StructureCompound.CompoundData format, T example, Function<ParsedCollections.ParsedMap, ParseResult<T>> reader, Function<T, ParsedCollections.ParsedMap> writer, Function<T, ParseResult<Boolean>> filter) {
        return new FunctionWriter<T>(format, example, reader, writer, filter, null, null);
    }

    public static <T> IConfigSerializer<T> withSync(StructureCompound.CompoundData format, T example, Function<ParsedCollections.ParsedMap, ParseResult<T>> reader, Function<T, ParsedCollections.ParsedMap> writer, Function<IReadBuffer, T> readBuffer, BiConsumer<IWriteBuffer, T> writeBuffer) {
        return new FunctionWriter<T>(format, example, reader, writer, null, readBuffer, writeBuffer);
    }

    public static <T> IConfigSerializer<T> withSync(StructureCompound.CompoundData format, T example, Function<ParsedCollections.ParsedMap, ParseResult<T>> reader, Function<T, ParsedCollections.ParsedMap> writer, Function<T, ParseResult<Boolean>> filter, Function<IReadBuffer, T> readBuffer, BiConsumer<IWriteBuffer, T> writeBuffer) {
        return new FunctionWriter<T>(format, example, reader, writer, filter, readBuffer, writeBuffer);
    }

    public static class FunctionWriter<T>
    implements IConfigSerializer<T> {
        StructureCompound.CompoundData format;
        T example;
        Function<ParsedCollections.ParsedMap, ParseResult<T>> reader;
        Function<T, ParsedCollections.ParsedMap> writer;
        Function<T, ParseResult<Boolean>> filter;
        Function<IReadBuffer, T> readBuffer;
        BiConsumer<IWriteBuffer, T> writeBuffer;

        public FunctionWriter(StructureCompound.CompoundData format, T example, Function<ParsedCollections.ParsedMap, ParseResult<T>> reader, Function<T, ParsedCollections.ParsedMap> writer, Function<T, ParseResult<Boolean>> filter, Function<IReadBuffer, T> readBuffer, BiConsumer<IWriteBuffer, T> writeBuffer) {
            this.format = format;
            this.example = example;
            this.reader = reader;
            this.writer = writer;
            this.filter = filter;
            this.readBuffer = readBuffer;
            this.writeBuffer = writeBuffer;
        }

        @Override
        public T getExample() {
            return this.example;
        }

        @Override
        public StructureCompound.CompoundData getFormat() {
            return this.format;
        }

        @Override
        public ParseResult<Boolean> isValid(T value) {
            return this.filter == null ? ParseResult.success(true) : this.filter.apply(value);
        }

        @Override
        public ParseResult<T> deserialize(ParsedCollections.ParsedMap value) {
            return this.reader.apply(value);
        }

        @Override
        public ParsedCollections.ParsedMap serialize(T value) {
            return this.writer.apply(value);
        }

        @Override
        public T deserialize(IReadBuffer buffer) {
            if (this.readBuffer == null || this.writeBuffer == null) {
                throw new UnsupportedOperationException("No Read/Write Buffer Provided");
            }
            return this.readBuffer.apply(buffer);
        }

        @Override
        public void serialize(IWriteBuffer buffer, T value) {
            if (this.readBuffer == null || this.writeBuffer == null) {
                throw new UnsupportedOperationException("No Read/Write Buffer Provided");
            }
            this.writeBuffer.accept(buffer, (IWriteBuffer)value);
        }
    }
}

