/*
 * Decompiled with CFR 0.152.
 */
package toni.immersivemessages.renderers;

import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import org.joml.Vector3i;
import toni.immersivemessages.api.ImmersiveMessage;
import toni.immersivemessages.renderers.ITooltipRenderer;
import toni.immersivemessages.util.AnimationUtil;
import toni.immersivemessages.util.RenderUtil;
import xyz.flirora.caxton.layout.CaxtonText;
import xyz.flirora.caxton.layout.LayoutCache;
import xyz.flirora.caxton.render.CaxtonTextRenderer;

public class CaxtonRenderer
implements ITooltipRenderer {
    @Override
    public void render(ImmersiveMessage tooltip, GuiGraphics graphics, float deltaTicks) {
        CaxtonTextRenderer renderer = CaxtonTextRenderer.getInstance();
        ArrayList<FormattedText> textLines = new ArrayList<FormattedText>();
        textLines.add((FormattedText)tooltip.getText());
        Vector3i size = CaxtonRenderer.wrapText(textLines, tooltip, renderer, tooltip.parent == null);
        Vector2i bgOffset = tooltip.anchor.getNormalized();
        bgOffset = bgOffset.add((Vector2ic)tooltip.align.getNormalized().mul(-1));
        if (tooltip.background) {
            RenderUtil.drawBackground(tooltip, graphics, size, bgOffset.mul(-3, new Vector2i()), deltaTicks);
        }
        int yOffset = 0;
        for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
            FormattedText line = textLines.get(lineNumber);
            if (line != null) {
                CaxtonText text = CaxtonText.fromFormatted((FormattedText)line, arg_0 -> ((CaxtonTextRenderer)renderer).getFontStorage(arg_0), (Style)tooltip.style, (boolean)false, (boolean)renderer.rtl, (LayoutCache)renderer.getHandler().getCache());
                float lineWidth = renderer.getHandler().getWidth(text);
                lineWidth = CaxtonRenderer.adjustLineWidthForTypewriter(tooltip, graphics, lineWidth, (FormattedText)(textLines.size() == 1 ? tooltip.getRawText() : line), renderer);
                graphics.pose().pushPose();
                AnimationUtil.applyPose(tooltip.animation, graphics, bgOffset.mul(-6, new Vector2i()), tooltip.anchor, tooltip.align, lineWidth, size.y);
                graphics.pose().translate(0.0, 0.0, (double)0.1f);
                renderer.draw(text, 0.0f, (float)yOffset, tooltip.animation.getColor(), tooltip.shadow, graphics.pose().last().pose(), (MultiBufferSource)graphics.bufferSource(), true, 0, 255, 0, 1000.0f);
                graphics.pose().popPose();
            }
            yOffset += 10;
        }
    }

    private static float adjustLineWidthForTypewriter(ImmersiveMessage tooltip, GuiGraphics graphics, float lineWidth, FormattedText line, CaxtonTextRenderer renderer) {
        if (!tooltip.typewriter || tooltip.typewriterCenterAligned) {
            return lineWidth;
        }
        if (tooltip.wrapMaxWidth >= 0) {
            return tooltip.wrapMaxWidth == 0 ? (float)graphics.guiWidth() / 2.0f : Math.max((float)tooltip.wrapMaxWidth, (float)graphics.guiWidth() / 2.0f);
        }
        CaxtonText rawText = CaxtonText.fromFormatted((FormattedText)line, arg_0 -> ((CaxtonTextRenderer)renderer).getFontStorage(arg_0), (Style)tooltip.style, (boolean)false, (boolean)renderer.rtl, (LayoutCache)renderer.getHandler().getCache());
        return renderer.getHandler().getWidth(rawText);
    }

    private static Vector3i wrapText(ArrayList<FormattedText> textLines, ImmersiveMessage tooltip, CaxtonTextRenderer renderer, boolean isCallingFromRoot) {
        if (tooltip.parent == null || isCallingFromRoot) {
            Vector3i size = RenderUtil.wrapText(textLines, tooltip.wrapMaxWidth, line -> {
                CaxtonText txt = CaxtonText.fromFormatted((FormattedText)line, arg_0 -> ((CaxtonTextRenderer)renderer).getFontStorage(arg_0), (Style)tooltip.style, (boolean)false, (boolean)renderer.rtl, (LayoutCache)renderer.getHandler().getCache());
                return (int)renderer.getHandler().getWidth(txt);
            });
            if (tooltip.subtext != null) {
                ArrayList<FormattedText> subtextLines = new ArrayList<FormattedText>();
                subtextLines.add((FormattedText)tooltip.subtext.getText());
                Vector3i subtextSize = CaxtonRenderer.wrapText(subtextLines, tooltip.subtext, renderer, true);
                float yOffset = Math.max(0.0f, tooltip.subtext.yLevel - tooltip.yLevel);
                float xOffset = Math.max(0.0f, tooltip.subtext.xLevel - tooltip.xLevel);
                return new Vector3i(Math.max(size.x, (int)xOffset + subtextSize.x), Math.max(size.y, (int)yOffset + subtextSize.y), Math.max(size.z, subtextSize.z));
            }
            return size;
        }
        return CaxtonRenderer.wrapText(textLines, tooltip.parent, renderer, false);
    }
}

