/*
 * Decompiled with CFR 0.152.
 */
package toni.immersivemessages;

import java.util.LinkedList;
import java.util.Queue;
import lombok.Generated;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import toni.immersivemessages.api.ImmersiveMessage;
import toni.immersivemessages.config.AllConfigs;
import toni.immersivemessages.renderers.CaxtonRenderer;
import toni.immersivemessages.renderers.ITooltipRenderer;
import toni.immersivemessages.renderers.VanillaRenderer;
import toni.lib.utils.PlatformUtils;

public class ImmersiveMessagesManager {
    private static final Queue<ImmersiveMessage> tooltipQueue = new LinkedList<ImmersiveMessage>();
    private static final ITooltipRenderer renderer = ImmersiveMessagesManager.initRenderer();
    private static final float NANOSECONDS_PER_TICK = 5.0E7f;
    private static long lastTime = System.nanoTime();
    private static ImmersiveMessage currentTooltip;
    private static double countdownToNextTooltip;

    static void render(GuiGraphics graphics, DeltaTracker delta) {
        long currentTime = System.nanoTime();
        if (Minecraft.getInstance().isPaused()) {
            lastTime = currentTime;
            return;
        }
        float partialTicks = delta.getRealtimeDeltaTicks();
        countdownToNextTooltip -= (double)partialTicks;
        if (currentTooltip == null) {
            if (tooltipQueue.isEmpty()) {
                return;
            }
            currentTooltip = tooltipQueue.remove();
        }
        if (countdownToNextTooltip > 0.0) {
            return;
        }
        ImmersiveMessagesManager.renderTooltip(graphics, partialTicks, currentTooltip, 0);
    }

    static void renderTooltip(GuiGraphics graphics, float deltaTicks, ImmersiveMessage tooltip, int depth) {
        tooltip.tick(deltaTicks);
        tooltip.animation.advancePlayhead(deltaTicks / 20.0f);
        if (depth == 0 && tooltip.animation.getCurrent() >= tooltip.animation.duration) {
            currentTooltip = null;
            countdownToNextTooltip = 20.0 * (Double)AllConfigs.client().timeBetweenMessages.get();
            return;
        }
        renderer.render(tooltip, graphics, deltaTicks);
        if (tooltip.subtext != null) {
            ImmersiveMessagesManager.renderTooltip(graphics, deltaTicks, tooltip.subtext, depth + 1);
        }
    }

    private static ITooltipRenderer initRenderer() {
        if (PlatformUtils.isModLoaded((String)"caxton")) {
            return new CaxtonRenderer();
        }
        return new VanillaRenderer();
    }

    static void showToPlayer(LocalPlayer player, ImmersiveMessage tooltip) {
        tooltipQueue.add(tooltip);
    }

    public static boolean hasTooltip() {
        return currentTooltip != null;
    }

    public static int queueCount() {
        return tooltipQueue.size();
    }

    @Generated
    public static ITooltipRenderer getRenderer() {
        return renderer;
    }

    static {
        countdownToNextTooltip = 0.0;
    }
}

