/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.recipe;

import com.buuz135.sushigocrafting.proxy.SushiContent;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

public class FermentingBarrelRecipe
implements Recipe<CraftingInput> {
    public static final MapCodec<FermentingBarrelRecipe> CODEC = RecordCodecBuilder.mapCodec(in -> in.group((App)Ingredient.CODEC.optionalFieldOf("input").forGetter(fermentingBarrelRecipe -> Optional.of(fermentingBarrelRecipe.input)), (App)FluidStack.CODEC.fieldOf("fluid").forGetter(FermentingBarrelRecipe::getFluid), (App)ItemStack.CODEC.fieldOf("output").forGetter(FermentingBarrelRecipe::getOutput)).apply((Applicative)in, (ingredient, fluidStack, itemStack) -> new FermentingBarrelRecipe(ingredient.orElse(Ingredient.EMPTY), (FluidStack)fluidStack, (ItemStack)itemStack)));
    public static List<FermentingBarrelRecipe> RECIPES = new ArrayList<FermentingBarrelRecipe>();
    public Ingredient input = Ingredient.EMPTY;
    public FluidStack fluid = FluidStack.EMPTY;
    public ItemStack output;

    public FermentingBarrelRecipe() {
    }

    public FermentingBarrelRecipe(Ingredient input, FluidStack stack, ItemStack output) {
        this.input = input;
        this.fluid = stack;
        this.output = output;
        RECIPES.add(this);
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        return false;
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)SushiContent.RecipeSerializers.FERMENTING_BARREL.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)SushiContent.RecipeTypes.FERMENTING_BARREL.get();
    }

    public Ingredient getInput() {
        return this.input;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public void save(RecipeOutput output, ResourceLocation id) {
        output.accept(id, (Recipe)this, null);
    }
}

