/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.item;

import com.buuz135.sushigocrafting.api.IFoodIngredient;
import com.buuz135.sushigocrafting.api.impl.FoodAPI;
import com.buuz135.sushigocrafting.item.SushiDataComponent;
import com.buuz135.sushigocrafting.item.SushiItem;
import com.buuz135.sushigocrafting.proxy.SushiContent;
import com.hrznstudio.titanium.api.ISpecialCreativeTabItem;
import java.awt.Color;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;

public class AmountItem
extends SushiItem
implements ISpecialCreativeTabItem {
    private final int minAmount;
    private final int maxAmount;
    private final int maxCombineAmount;

    public AmountItem(Item.Properties properties, String category, int minAmount, int maxAmount, int maxCombineAmount, boolean foodHurts) {
        super(properties.food(new FoodProperties.Builder().nutrition(2).saturationModifier(0.3f).effect(new MobEffectInstance(MobEffects.POISON, 100, 0), foodHurts ? 0.6f : 0.01f).build()), category);
        this.minAmount = minAmount;
        this.maxAmount = maxAmount;
        this.maxCombineAmount = maxCombineAmount;
    }

    public static ItemStack combineStacks(ItemStack first, ItemStack second) {
        if (!first.is(second.getItem())) {
            return null;
        }
        Item item = first.getItem();
        if (item instanceof AmountItem) {
            AmountItem firstAmount = (AmountItem)item;
            item = second.getItem();
            if (item instanceof AmountItem) {
                AmountItem secondAmount = (AmountItem)item;
                first.set(SushiDataComponent.AMOUNT, (Object)Math.min(firstAmount.getMaxCombineAmount(), firstAmount.getCurrentAmount(first) + secondAmount.getCurrentAmount(second)));
                return first;
            }
        }
        return null;
    }

    public void onCraftedBy(ItemStack stack, Level worldIn, Player playerIn) {
        super.onCraftedBy(stack, worldIn, playerIn);
        if (!stack.has(SushiDataComponent.AMOUNT)) {
            stack.set(SushiDataComponent.AMOUNT, (Object)(worldIn.random.nextInt(this.maxAmount - this.minAmount) + this.minAmount));
        }
    }

    public boolean isBarVisible(ItemStack stack) {
        return stack.has(SushiDataComponent.AMOUNT);
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round((float)((Integer)stack.getOrDefault(SushiDataComponent.AMOUNT, (Object)0)).intValue() * 13.0f / (float)this.maxCombineAmount);
    }

    public int getBarColor(ItemStack stack) {
        return Color.YELLOW.getRGB();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (stack.has(SushiDataComponent.AMOUNT)) {
            tooltipComponents.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + Component.translatable((String)"text.sushigocrafting.amount").getString() + " " + String.valueOf(stack.get(SushiDataComponent.AMOUNT)) + "/" + this.maxCombineAmount + " gr.")));
        }
    }

    public int getCurrentAmount(ItemStack stack) {
        return (Integer)stack.getOrDefault(SushiDataComponent.AMOUNT, (Object)0);
    }

    public int getMinAmount() {
        return this.minAmount;
    }

    public int getMaxAmount() {
        return this.maxAmount;
    }

    public int getMaxCombineAmount() {
        return this.maxCombineAmount;
    }

    public ItemStack withAmount(int amount) {
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.set(SushiDataComponent.AMOUNT, (Object)amount);
        return stack;
    }

    public ItemStack random(Player entity, Level world) {
        int extra = 0;
        if (entity != null && entity.hasEffect(SushiContent.Effects.STEADY_HANDS.getDelegate())) {
            extra += (entity.getEffect(SushiContent.Effects.STEADY_HANDS.getDelegate()).getAmplifier() + 1) * this.getMinAmount();
        }
        return this.withAmount(Math.min(this.getMaxCombineAmount(), extra + world.random.nextInt(this.getMaxAmount() - this.getMinAmount()) + this.getMinAmount()));
    }

    public void consume(IFoodIngredient ingredient, ItemStack stack, int amountLevel) {
        int amount = (int)((double)((Integer)stack.getOrDefault(SushiDataComponent.AMOUNT, (Object)0)).intValue() - (double)(ingredient.getDefaultAmount() * (amountLevel + 1)) / 5.0);
        stack.set(SushiDataComponent.AMOUNT, (Object)amount);
        if (amount <= 0) {
            stack.shrink(1);
        }
    }

    public boolean canConsume(IFoodIngredient ingredient, ItemStack stack, int amountLevel) {
        int amount = (int)((double)(ingredient.getDefaultAmount() * (amountLevel + 1)) / 5.0);
        return !stack.isEmpty() && (Integer)stack.getOrDefault(SushiDataComponent.AMOUNT, (Object)0) >= amount;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
        if (entityLiving instanceof Player) {
            worldIn.playSound(null, entityLiving.getX(), entityLiving.getY(), entityLiving.getZ(), this.getEatingSound(), SoundSource.NEUTRAL, 1.0f, 1.0f + (worldIn.random.nextFloat() - worldIn.random.nextFloat()) * 0.4f);
            ((Player)entityLiving).getFoodData().eat(stack.getItem().getFoodProperties(stack, entityLiving));
            for (FoodProperties.PossibleEffect pair : stack.getItem().getFoodProperties(stack, entityLiving).effects()) {
                if (worldIn.isClientSide || pair.effect() == null || !(worldIn.random.nextFloat() < pair.probability())) continue;
                entityLiving.addEffect(new MobEffectInstance(pair.effect()));
            }
            if (!((Player)entityLiving).getAbilities().instabuild) {
                this.consume(FoodAPI.get().getIngredientFromItem(this), stack, 6);
            }
        }
        return stack;
    }

    public void addToTab(BuildCreativeModeTabContentsEvent event) {
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.set(SushiDataComponent.AMOUNT, (Object)(this.maxAmount / 2));
        event.accept(stack);
    }
}

