/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.block.plant;

import com.buuz135.sushigocrafting.block.SushiGoCraftingBlock;
import com.buuz135.sushigocrafting.proxy.SushiContent;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.IShearable;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class AvocadoLeavesBlock
extends SushiGoCraftingBlock
implements IShearable,
BonemealableBlock {
    public static final IntegerProperty DISTANCE = BlockStateProperties.DISTANCE;
    public static final BooleanProperty PERSISTENT = BlockStateProperties.PERSISTENT;
    public static final IntegerProperty STAGE = IntegerProperty.create((String)"stage", (int)0, (int)2);

    public AvocadoLeavesBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DISTANCE, (Comparable)Integer.valueOf(7))).setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(false))).setValue((Property)STAGE, (Comparable)Integer.valueOf(0)));
    }

    private static BlockState updateDistance(BlockState state, LevelAccessor worldIn, BlockPos pos) {
        int i = 7;
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            blockpos$mutable.setWithOffset((Vec3i)pos, direction);
            i = Math.min(i, AvocadoLeavesBlock.getDistance(worldIn.getBlockState((BlockPos)blockpos$mutable)) + 1);
            if (i == 1) break;
        }
        return (BlockState)state.setValue((Property)DISTANCE, (Comparable)Integer.valueOf(i));
    }

    private static int getDistance(BlockState neighbor) {
        if (((HolderSet.Named)BuiltInRegistries.BLOCK.getTag(BlockTags.LOGS).get()).contains(neighbor.getBlockHolder())) {
            return 0;
        }
        return neighbor.getBlock() instanceof AvocadoLeavesBlock || neighbor.getBlock() instanceof LeavesBlock ? (Integer)neighbor.getValue((Property)DISTANCE) : 7;
    }

    public VoxelShape getBlockSupportShape(BlockState state, BlockGetter reader, BlockPos pos) {
        return Shapes.empty();
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)DISTANCE) == 7 && (Boolean)state.getValue((Property)PERSISTENT) == false || (Integer)state.getValue((Property)STAGE) == 1;
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        worldIn.setBlock(pos, AvocadoLeavesBlock.updateDistance(state, (LevelAccessor)worldIn, pos), 3);
        state = worldIn.getBlockState(pos);
        if (!((Boolean)state.getValue((Property)PERSISTENT)).booleanValue() && (Integer)state.getValue((Property)DISTANCE) == 7) {
            AvocadoLeavesBlock.dropResources((BlockState)state, (Level)worldIn, (BlockPos)pos);
            worldIn.removeBlock(pos, false);
        }
        if ((Integer)state.getValue((Property)STAGE) == 1 && random.nextInt(3) == 0) {
            worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)STAGE, (Comparable)Integer.valueOf(2)));
        }
    }

    public void tick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        worldIn.setBlock(pos, AvocadoLeavesBlock.updateDistance(state, (LevelAccessor)worldIn, pos), 3);
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1;
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        int i = AvocadoLeavesBlock.getDistance(facingState) + 1;
        if (i != 1 || (Integer)stateIn.getValue((Property)DISTANCE) != i) {
            worldIn.scheduleTick(currentPos, (Block)this, 1);
        }
        return stateIn;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, Random rand) {
        BlockPos blockpos;
        BlockState blockstate;
        if (!(!worldIn.isRainingAt(pos.above()) || rand.nextInt(15) != 1 || (blockstate = worldIn.getBlockState(blockpos = pos.below())).canOcclude() && blockstate.isFaceSturdy((BlockGetter)worldIn, blockpos, Direction.UP))) {
            double d0 = (double)pos.getX() + rand.nextDouble();
            double d1 = (double)pos.getY() - 0.05;
            double d2 = (double)pos.getZ() + rand.nextDouble();
            worldIn.addParticle((ParticleOptions)ParticleTypes.DRIPPING_WATER, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DISTANCE, PERSISTENT, STAGE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return AvocadoLeavesBlock.updateDistance((BlockState)this.defaultBlockState().setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(true)), (LevelAccessor)context.getLevel(), context.getClickedPos());
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if ((Integer)state.getValue((Property)STAGE) == 2) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)SushiContent.Items.AVOCADO.get()));
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)STAGE, (Comparable)Integer.valueOf(1)));
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return (Integer)blockState.getValue((Property)STAGE) > 0;
    }

    public boolean isBonemealSuccess(Level worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        return (Integer)state.getValue((Property)STAGE) == 1;
    }

    public void performBonemeal(ServerLevel worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)STAGE, (Comparable)Integer.valueOf(2)));
    }
}

