/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.explosiveenhancement.particle.custom;

import dev.xylonity.explosiveenhancement.config.ExplosiveValues;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class SmokeParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;

    SmokeParticle(ClientLevel world, double x, double y, double z, SpriteSet spriteProvider, double velX, double velY, double velZ) {
        super(world, x, y, z);
        this.friction = 0.6f;
        this.sprites = spriteProvider;
        this.lifetime = this.random.nextInt(35) + 1;
        if (velZ == 0.0) {
            this.quadSize = (float)velX * 0.25f;
            this.lifetime += (int)(velX * (double)this.random.nextInt(3, 22));
            this.xd = 0.0;
            this.zd = 0.0;
        } else if (velX == 0.15 || velX == -0.15) {
            this.quadSize = (float)velZ * 0.25f;
            this.lifetime += (int)(velZ * (double)this.random.nextInt(3, 22));
            this.xd = velX * (velZ * 0.5);
            this.zd = 0.0;
        } else if (velZ == 0.15 || velZ == -0.15) {
            this.quadSize = (float)velX * 0.25f;
            this.lifetime += (int)(velX * (double)this.random.nextInt(3, 22));
            this.xd = 0.0;
            this.zd = velZ * (velX * 0.5);
        }
        this.yd = velY / 1.85;
        this.gravity = 3.0E-6f;
        this.hasPhysics = true;
        this.setSpriteFromAge(spriteProvider);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.setSpriteFromAge(this.sprites);
            if (this.age == 12) {
                this.xd = 0.0;
                this.yd = 0.05;
                this.zd = 0.0;
            }
            this.move(this.xd, this.yd, this.zd);
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    protected int getLightColor(float tint) {
        if (ExplosiveValues.emissiveExplosion && (double)this.age <= (double)this.lifetime * 0.12) {
            return 0xF000F0;
        }
        if (ExplosiveValues.emissiveExplosion && (double)this.age <= (double)this.lifetime * 0.17) {
            return Mth.clamp((int)(super.getLightColor(tint) + this.age + 30), (int)super.getLightColor(tint), (int)0xF000F0);
        }
        return super.getLightColor(tint);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SimpleParticleType particleType, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new SmokeParticle(level, x, y, z, this.sprites, dx, dy, dz);
        }
    }
}

