/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.explosiveenhancement.mixin;

import dev.xylonity.explosiveenhancement.registry.ExplosiveParticleManager;
import dev.xylonity.explosiveenhancement.registry.IExplosiveParticleHandler;
import java.util.Map;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ParticleEngine.class})
public class ParticleManagerMixin
implements IExplosiveParticleHandler {
    @Shadow
    @Final
    private Map<ResourceLocation, ParticleProvider<?>> providers;
    @Shadow
    @Final
    private Map<ResourceLocation, ParticleEngine.MutableSpriteSet> spriteSets;
    @Shadow
    protected ClientLevel level;

    @Override
    public <P extends ParticleOptions, E extends ParticleType<P>> void registerMutableSprite(DeferredHolder<ParticleType<?>, E> type, ParticleEngine.SpriteParticleRegistration<P> registration) {
        ParticleEngine.MutableSpriteSet spriteSet = new ParticleEngine.MutableSpriteSet();
        this.spriteSets.put(type.getId(), spriteSet);
        this.providers.put(type.getId(), registration.create((SpriteSet)spriteSet));
    }

    @Inject(method={"makeParticle"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/Registry;getKey(Ljava/lang/Object;)Lnet/minecraft/resources/ResourceLocation;")}, cancellable=true)
    private <T extends ParticleOptions> void onMakeParticle(T pParticleData, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed, CallbackInfoReturnable<Particle> cir) {
        ResourceLocation newResource;
        ParticleProvider<?> particleProvider;
        ResourceLocation original = BuiltInRegistries.PARTICLE_TYPE.getKey((Object)pParticleData.getType());
        if (ExplosiveParticleManager.PARTICLE_TYPES != null && (particleProvider = this.providers.get(newResource = original == null ? ExplosiveParticleManager.PARTICLE_TYPES.getKey((Object)pParticleData.getType()) : original)) != null) {
            Particle particle = particleProvider.createParticle(pParticleData, this.level, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed);
            cir.setReturnValue((Object)particle);
        }
    }
}

