/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.cl;

import cpw.mods.cl.ModularURLHandler;
import cpw.mods.niofs.union.UnionPath;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Function;

public class UnionURLStreamHandler
implements ModularURLHandler.IURLProvider {
    @Override
    public String protocol() {
        return "union";
    }

    @Override
    public Function<URL, InputStream> inputStreamFunction() {
        return u -> {
            try {
                Path patt0$temp = Paths.get(u.toURI());
                if (patt0$temp instanceof UnionPath) {
                    UnionPath upath = (UnionPath)patt0$temp;
                    return upath.buildInputStream();
                }
                throw new IllegalArgumentException("Invalid Path " + String.valueOf(u.toURI()) + " at UnionURLStreamHandler");
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        };
    }

    @Override
    public long getLastModified(URL u) {
        try {
            return Files.getLastModifiedTime(Paths.get(u.toURI()), new LinkOption[0]).toMillis();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public long getContentLength(URL u) {
        try {
            return Files.size(Paths.get(u.toURI()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

